<?php
/**
 * This file is used for translation strings.
 *
 * @author  Tech Banker
 * @package wp-captcha-booster/includes
 * @version 1.0.0
 */
if (!defined("ABSPATH")) {
   exit;
} //exit if accessed directly
if (!is_user_logged_in()) {
   return;
} else {
   $access_granted = false;
   foreach ($user_role_permission as $permission) {
      if (current_user_can($permission)) {
         $access_granted = true;
         break;
      }
   }
   if (!$access_granted) {
      return;
   } else {
      
      $cpb_support_forum = __("Ask For Help","wp-captcha-booster");
      $cpb_upgrade_kanow_about = __("Know about", "wp-captcha-booster");
      $cpb_full_features = __("Full Features", "wp-captcha-booster");
      $cpb_chek_our = __("or check our", "wp-captcha-booster");
      $cpb_online_demos = __("Online Demos", "wp-captcha-booster");
      
      //footer

      $message_premium_edition = __("This feature is available only in Premium Editions! <br> Kindly Purchase to unlock it!", "wp-captcha-booster");
      $cpb_update_captcha_type = __("Captcha Type has been saved Successfully", "wp-captcha-booster");
      $cpb_success = __("Success!", "wp-captcha-booster");
      $cpb_update_error_message = __("Error Messages have been saved Successfully", "wp-captcha-booster");
      $cpb_update_display_settings = __("Display Settings have been saved Successfully", "wp-captcha-booster");
      $cpb_update_blocking_options = __("Blocking Options have been saved Successfully", "wp-captcha-booster");
      $cpb_ip_address_block = __("IP Address has been blocked Successfully", "wp-captcha-booster");
      $cpb_ip_range_block = __("IP Range has been blocked Successfully", "wp-captcha-booster");
      $cpb_delete_ip_address = __("IP Address has been deleted Successfully", "wp-captcha-booster");
      $cpb_delete_ip_range = __("IP Range has been deleted Successfully", "wp-captcha-booster");
      $cpb_update_other_settings = __("Other Settings have been saved Successfully", "wp-captcha-booster");
      $cpb_number_of_digits = __("Please provide Number between 1 to 100", "wp-captcha-booster");
      $cpb_number_of_captcha_character = __("Please provide Number between 1 to 10", "wp-captcha-booster");
      $cpb_error_message = __("Error Message", "wp-captcha-booster");
      $cpb_arithmetic_action = __("Please choose at least one Arithmetic action!", "wp-captcha-booster");
      $cpb_ip_address = __("IP Address", "wp-captcha-booster");
      $cpb_location = __("Location", "wp-captcha-booster");
      $cpb_latitude = __("Latitude", "wp-captcha-booster");
      $cpb_longitude = __("Longitude", "wp-captcha-booster");
      $cpb_na = __("N/A", "wp-captcha-booster");
      $cpb_confirm_delete = __("Are you sure you want to delete ?", "wp-captcha-booster");
      $cpb_valid_ip_range = __("Please provide valid IP Range", "wp-captcha-booster");
      $cpb_valid_ip_address = __("Please provide valid IP Address", "wp-captcha-booster");
      $cpb_ip_address_already_blocked = __("This IP Address has been already blocked!", "wp-captcha-booster");
      $cpb_notification = __("Notification!", "wp-captcha-booster");
      $cpb_ip_range_already_blocked = __("This IP Range has been already blocked!", "wp-captcha-booster");
      $cpb_delete_login_logs = __("A Login Log has been deleted Successfully", "wp-captcha-booster");
      $cpb_delete_visitor_logs = __("A Visitor Log has been deleted Successfully", "wp-captcha-booster");
      $cpb_block_own_ip_address = __("You cannot block your own IP Address!", "wp-captcha-booster");
      $cpb_block_own_ip_range = __("You cannot block this IP Range as your IP Address lies between this Range!", "wp-captcha-booster");

      //captcha setup
      $cpb_captcha_booster_type_tooltip = __("In this field, you would need to choose between different types of captcha. You could choose between Text Captcha and Logical Captcha", "wp-captcha-booster");
      $cpb_captcha_booster_text_captcha = __("Text Captcha", "wp-captcha-booster");
      $cpb_captcha_booster_logical_captcha = __("Logical Captcha", "wp-captcha-booster");
      $cpb_captcha_booster_character_title = __("Captcha Characters", "wp-captcha-booster");
      $cpb_captcha_booster_character_tooltip = __("In this field, you would need to provide number of characters to be used for creating a captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_character_placeholder = __("Please provide Captcha Characters", "wp-captcha-booster");
      $cpb_captcha_booster_string_type_title = __("Captcha String Type", "wp-captcha-booster");
      $cpb_captcha_booster_string_type_tooltip = __("In this field, you would need to choose whether to create captcha control with Alphabets and Digits Only Alphabets Only Digits", "wp-captcha-booster");
      $cpb_captcha_booster_alphabets_digits = __("Alphabets And Digits", "wp-captcha-booster");
      $cpb_captcha_booster_only_alphabets = __("Only Alphabets", "wp-captcha-booster");
      $cpb_captcha_booster_only_digits = __("Only Digits", "wp-captcha-booster");
      $cpb_captcha_booster_text_case_title = __("Text Case", "wp-captcha-booster");
      $cpb_captcha_booster_text_case_tooltip = __("In this field, you would need to choose whether to create captcha control with Upper Case Lower Case Random", "wp-captcha-booster");
      $cpb_captcha_booster_upper_case = __("Upper Case", "wp-captcha-booster");
      $cpb_captcha_booster_lower_case = __("Lower Case", "wp-captcha-booster");
      $cpb_captcha_booster_random_case = __("Random", "wp-captcha-booster");
      $cpb_captcha_booster_case_sensitive_title = __("Case Sensitive", "wp-captcha-booster");
      $cpb_captcha_booster_case_sensitive_tooltip = __("In this field, you would need to choose whether to create captcha control with Case Sensitive or vice versa", "wp-captcha-booster");
      $cpb_captcha_booster_width_title = __("Captcha Width", "wp-captcha-booster");
      $cpb_captcha_booster_width_tooltip = __("In this field, you would need to provide a width of captcha control in pixels", "wp-captcha-booster");
      $cpb_captcha_booster_width_placeholder = __("Please provide Captcha Width", "wp-captcha-booster");
      $cpb_captcha_booster_height_title = __("Captcha Height", "wp-captcha-booster");
      $cpb_captcha_booster_height_tooltip = __("In this field, you would need to provide a height of captcha control in pixels", "wp-captcha-booster");
      $cpb_captcha_booster_height_placeholder = __("Please provide Captcha Height", "wp-captcha-booster");
      $cpb_captcha_booster_background_title = __("Captcha Background", "wp-captcha-booster");
      $cpb_captcha_booster_background_tooltip = __("In this field, you would need to choose different backgrounds for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern1 = __("Pattern 1", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern2 = __("Pattern 2", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern3 = __("Pattern 3", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern4 = __("Pattern 4", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern5 = __("Pattern 5", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern6 = __("Pattern 6", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern7 = __("Pattern 7", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern8 = __("Pattern 8", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern9 = __("Pattern 9", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern10 = __("Pattern 10", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern11 = __("Pattern 11", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern12 = __("Pattern 12", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern13 = __("Pattern 13", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern14 = __("Pattern 14", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern15 = __("Pattern 15", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern16 = __("Pattern 16", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern17 = __("Pattern 17", "wp-captcha-booster");
      $cpb_captcha_booster_background_pattern18 = __("Pattern 18", "wp-captcha-booster");
      $cpb_captcha_booster_text_style_title = __("Text Style", "wp-captcha-booster");
      $cpb_captcha_booster_text_style_tooltip = __("In this field, you would need to set Font, Size and Font Color for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_text_font_title = __("Text Font", "wp-captcha-booster");
      $cpb_captcha_booster_text_font_tooltip = __("In this field, you would need to choose Font Type for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_border_style_title = __("Border Style", "wp-captcha-booster");
      $cpb_captcha_booster_border_style_tooltip = __("In this field, you would need to choose Border Color, Border Size and Border Type for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_border_solid = __("Solid", "wp-captcha-booster");
      $cpb_captcha_booster_border_dotted = __("Dotted", "wp-captcha-booster");
      $cpb_captcha_booster_border_dashed = __("Dashed", "wp-captcha-booster");
      $cpb_captcha_booster_lines_title = __("Lines", "wp-captcha-booster");
      $cpb_captcha_booster_lines_tooltip = __("In this field, you would need to provide number of lines for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_lines_placeholder = __("Please provide number of Lines", "wp-captcha-booster");
      $cpb_captcha_booster_lines_color_title = __("Lines Color", "wp-captcha-booster");
      $cpb_captcha_booster_lines_color_tooltip = __("In this field, you would need to choose Line Color for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_noise_level_title = __("Noise level", "wp-captcha-booster");
      $cpb_captcha_booster_noise_level_tooltip = __("In this field, you would need to provide Noise in captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_noise_level_placeholder = __("Please provide Noise Level", "wp-captcha-booster");
      $cpb_captcha_booster_noise_color_title = __("Noise Color", "wp-captcha-booster");
      $cpb_captcha_booster_noise_color_tooltip = __("In this field, you would need to choose Noise Color for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_text_transparency_title = __("Text Transparency %", "wp-captcha-booster");
      $cpb_captcha_booster_text_transparency_tooltip = __("In this field, you would need to provide Text Transparency for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_text_transparency_placeholder = __("Please provide Text Transparency", "wp-captcha-booster");
      $cpb_captcha_booster_signature_text_title = __("Signature Text", "wp-captcha-booster");
      $cpb_captcha_booster_signature_text_tooltip = __("In this field, you would need to provide Signature Text for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_signature_text_palceholder = __("Please provide Signature Text", "wp-captcha-booster");
      $cpb_captcha_booster_signature_style_title = __("Signature Style", "wp-captcha-booster");
      $cpb_captcha_booster_signature_style_tooltip = __("In this field, you would need to choose Signature Style and Signature Color for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_signature_font_title = __("Signature Font", "wp-captcha-booster");
      $cpb_captcha_booster_signature_font_tooltip = __("In this field, you would need to choose Font Family for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_shadow_color_title = __("Text Shadow Color", "wp-captcha-booster");
      $cpb_captcha_booster_shadow_color_tooltip = __("In this field, you would need to choose Text Shadow Color for captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_mathematical_title = __("Mathematical Operations", "wp-captcha-booster");
      $cpb_captcha_booster_mathematical_tooltip = __("In this field, you would need to choose whether to create a Captcha control with Arithmetic Relational Arrange Order", "wp-captcha-booster");
      $cpb_captcha_booster_arithmetic = __("Arithmetic", "wp-captcha-booster");
      $cpb_captcha_booster_relational = __("Relational", "wp-captcha-booster");
      $cpb_captcha_booster_arithmetic_title = __("Arithmetic Actions", "wp-captcha-booster");
      $cpb_captcha_booster_addition = __("Addition(+)", "wp-captcha-booster");
      $cpb_captcha_booster_subtraction = __("Subtraction(-)", "wp-captcha-booster");
      $cpb_captcha_booster_multiplication = __("Multiplication(*)", "wp-captcha-booster");
      $cpb_captcha_booster_division = __("Division(/)", "wp-captcha-booster");
      $cpb_captcha_booster_arithmetic_tooltip = __("In this field, you would need to choose specific arithmetic actions to create a captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_relational_title = __("Relational Actions", "wp-captcha-booster");
      $cpb_captcha_booster_relational_tooltip = __("In this field, you would need to choose specific relational actions to create a captcha control", "wp-captcha-booster");
      $cpb_captcha_booster_largest_number = __("Largest Number", "wp-captcha-booster");
      $cpb_captcha_booster_smallest_number = __("Smallest Number", "wp-captcha-booster");
      $cpb_captcha_booster_arrange_title = __("Arrange Order", "wp-captcha-booster");
      $cpb_captcha_booster_arrange_tooltip = __("In this field, you would need to choose the specific arranging order for captcha", "wp-captcha-booster");
      $cpb_captcha_booster_ascending_order = __("Ascending Order", "wp-captcha-booster");
      $cpb_captcha_booster_descending_order = __("Descending Order", "wp-captcha-booster");

      //other settings
      $cpb_other_settings_live_traffic_monitoring_label = __("Live Traffic Monitoring", "wp-captcha-booster");
      $cpb_other_settings_live_traffic_monitoring_tooltip = __("If you would like to monitor details of user who are currently visiting the website and pages visited by them, then choose enable or vice-versa from the drop-down", "wp-captcha-booster");
      $cpb_other_settings_visitor_logs_monitoring_label = __("Visitor Logs Monitoring", "wp-captcha-booster");
      $cpb_other_settings_visitor_logs_monitoring_tooltip = __("If you would like to monitor details of user who are visiting the website and pages visited by them, then choose enable or vice-versa from the drop-down", "wp-captcha-booster");
      $cpb_other_settings_remove_tables = __("Remove Tables At Uninstall", "wp-captcha-booster");
      $cpb_other_settings_remove_tables_tootltip = __("In this field, you would need to choose a specific option whether to remove tables at Uninstall", "wp-captcha-booster");
      $cpb_other_settings_ip_address_fetching_method = __("How does Captcha Booster get IPs", "wp-captcha-booster");
      $cpb_other_settings_ip_address_tooltips = __("In this field, you would need to choose a specific option  for how does Captcha Booster get IPs", "wp-captcha-booster");
      $cpb_other_settings_ip_address_fetching_option1 = __("Let Captcha Booster use the most secure method to get visitor IP address. Prevents spoofing and works with most sites.", "wp-captcha-booster");
      $cpb_other_settings_ip_address_fetching_option2 = __("Use PHP's built in REMOTE_ADDR and don't use anything else. Very secure if this is compatible with your site.", "wp-captcha-booster");
      $cpb_other_settings_ip_address_fetching_option3 = __("Use the X-Forwarded-For HTTP header. Only use if you have a front-end proxy or spoofing may result.", "wp-captcha-booster");
      $cpb_other_settings_ip_address_fetching_option4 = __("Use the X-Real-IP HTTP header. Only use if you have a front-end proxy or spoofing may result.", "wp-captcha-booster");
      $cpb_other_settings_ip_address_fetching_option5 = __("Use the Cloudflare 'CF-Connecting-IP' HTTP header to get a visitor IP. Only use if you're using Cloudflare.", "wp-captcha-booster");

      //alert setup
      $cpb_alert_setup_email_fails_login_tooltip = __("In this field, you would need to choose Enable to automatically send an email to the Administrator when a user fails to login to your website", "wp-captcha-booster");
      $cpb_alert_setup_email_success_login_tooltip = __("In this field, you would need to choose Enable to automatically send an email to the Administrator when a user succeeds in login to your website", "wp-captcha-booster");
      $cpb_alert_setup_email_ip_address_blocked_tooltip = __("In this field, you would need to choose Enable to automatically send an email to the Administrator when an IP Address is being blocked to your website", "wp-captcha-booster");
      $cpb_alert_setup_email_ip_address_unblocked_tooltip = __("In this field, you would need to choose Enable to automatically send an email to the Administrator when an IP Address is being unblocked to your website", "wp-captcha-booster");
      $cpb_alert_setup_email_ip_range_blocked_tooltip = __("In this field, you would need to choose Enable to automatically send an email to the Administrator when an IP Range is being blocked to your website", "wp-captcha-booster");
      $cpb_alert_setup_email_ip_range_unblocked_tooltip = __("In this field, you would need to choose Enable to automatically send an email to the Administrator when an IP Range is being unblocked to your website", "wp-captcha-booster");
      $cpb_alert_setup_email_fails_login_title = __("Email when a User Fails Login", "wp-captcha-booster");
      $cpb_alert_setup_email_success_login_title = __("Email when a User Success Login", "wp-captcha-booster");
      $cpb_alert_setup_email_ip_address_blocked_title = __("Email when an IP Address is Blocked", "wp-captcha-booster");
      $cpb_alert_setup_email_ip_address_unblocked_title = __("Email when an IP Address is Unblocked", "wp-captcha-booster");
      $cpb_alert_setup_email_ip_range_blocked_title = __("Email when an IP Range is Blocked", "wp-captcha-booster");
      $cpb_alert_setup_email_ip_range_unblocked_title = __("Email when an IP Range is Unblocked", "wp-captcha-booster");

      //email template
      $cpb_email_templates_tooltip = __("In this field, you would need to choose a template to configure Settings", "wp-captcha-booster");
      $cpb_email_templates_choose_title = __("Choose Email Template", "wp-captcha-booster");
      $cpb_email_templates_send_to_title = __("Send To", "wp-captcha-booster");
      $cpb_email_templates_send_to_email_tooltip = __("In this field, you would need to provide a valid email address where you want email notification to go when a user successfully logs into your website", "wp-captcha-booster");
      $cpb_email_templates_send_email_address_placeholder = __("Please provide Email Address", "wp-captcha-booster");
      $cpb_email_templates_cc_title = __("Cc", "wp-captcha-booster");
      $cpb_email_templates_cc_email_tooltip = __("In this field, you would need to provide valid Cc Email Address", "wp-captcha-booster");
      $cpb_email_templates_cc_email_address_placeholder = __("Please provide Cc Email", "wp-captcha-booster");
      $cpb_email_templates_bcc_title = __("Bcc", "wp-captcha-booster");
      $cpb_email_templates_bcc_email_tooltip = __("In this field, you would need to provide valid Bcc Email Address", "wp-captcha-booster");
      $cpb_email_templates_bcc_email_address_placeholder = __("Please provide Bcc Email", "wp-captcha-booster");
      $cpb_email_templates_subject_tooltip = __("In this field, you would need to provide Subject for Email", "wp-captcha-booster");
      $cpb_email_templates_cpb_message_title = __("Message", "wp-captcha-booster");
      $cpb_email_templates_message_content_tooptip = __("In this field, you would need to provide the Content for Email", "wp-captcha-booster");
      $cpb_email_templates_successful_login = __("Template For User Successful Login", "wp-captcha-booster");
      $cpb_email_templates_failure_login = __("Template For User Failure Login", "wp-captcha-booster");
      $cpb_email_templates_ip_address_blocked = __("Template For IP Address Blocked", "wp-captcha-booster");
      $cpb_email_templates_ip_address_unblocked = __("Template For IP Address Unblocked", "wp-captcha-booster");
      $cpb_email_templates_ip_range_blocked = __("Template For IP Range Blocked", "wp-captcha-booster");
      $cpb_email_templates_ip_range_unblocked = __("Template For IP Range Unblocked", "wp-captcha-booster");

      //roles and capabilities
      $cpb_show_roles_and_capabilities_menu = __("Show Captcha Booster Menu", "wp-captcha-booster");
      $cpb_roles_and_capabilities_menu_tooltip = __("In this field, you would need to choose a specific role who can see Sidebar Menu", "wp-captcha-booster");
      $cpb_roles_and_capabilities_administrator = __("Administrator", "wp-captcha-booster");
      $cpb_roles_and_capabilities_author = __("Author", "wp-captcha-booster");
      $cpb_roles_and_capabilities_editor = __("Editor", "wp-captcha-booster");
      $cpb_roles_and_capabilities_contributor = __("Contributor", "wp-captcha-booster");
      $cpb_roles_and_capabilities_subscriber = __("Subscriber", "wp-captcha-booster");
      $cpb_roles_and_capabilities_others = __("Others", "wp-captcha-booster");
      $cpb_roles_and_capabilities_topbar_menu = __("Show Captcha Booster Top Bar Menu", "wp-captcha-booster");
      $cpb_roles_and_capabilities_topbar_menu_tooltip = __("In this field, you would need to choose enable or disable option to show Captcha Booster Top Bar Menu", "wp-captcha-booster");
      $cpb_roles_and_capabilities_administrator_role = __("An Administrator Role can do the following ", "wp-captcha-booster");
      $cpb_roles_and_capabilities_administrator_role_tooltip = __("In this field, you would need to choose specific page available for Administrator Access", "wp-captcha-booster");
      $cpb_roles_and_capabilities_author_role = __("An Author Role can do the following ", "wp-captcha-booster");
      $cpb_roles_and_capabilities_author_role_tooltip = __("In this field, you would need to choose specific page available for Author Access", "wp-captcha-booster");
      $cpb_roles_and_capabilities_editor_role = __("An Editor Role can do the following ", "wp-captcha-booster");
      $cpb_roles_and_capabilities_editor_role_tooltip = __("In this field, you would need to choose specific page available for Editor Access", "wp-captcha-booster");
      $cpb_roles_and_capabilities_contributor_role = __("A Contributor Role can do the following ", "wp-captcha-booster");
      $cpb_roles_and_capabilities_contributor_role_tooltip = __("In this field, you would need to choose specific page available for Contributor Access", "wp-captcha-booster");
      $cpb_roles_and_capabilities_subscriber_role = __("A Subscriber Role can do the following ", "wp-captcha-booster");
      $cpb_roles_and_capabilities_subscriber_role_tooltip = __("In this field, you would need to choose specific page available for Subscriber Access", "wp-captcha-booster");
      $cpb_roles_and_capabilities_other_role = __("Other Roles can do the following ", "wp-captcha-booster");
      $cpb_roles_and_capabilities_other_role_tooltip = __("Please choose specific page available for Others Role Access.", "wp-captcha-booster");
      $cpb_roles_and_capabilities_other_roles_capabilities = __("Please tick the appropriate capabilities for security purposes ", "wp-captcha-booster");
      $cpb_roles_and_capabilities_other_roles_capabilities_tooltip = __("Only users with these capabilities can access Captcha Booster", "wp-captcha-booster");

      //live traffic and login logs
      $cpb_delete_live_traffic = __("Live Traffic has been deleted Successfully", "wp-captcha-booster");
      $cpb_recent_login_logs_start_date_tooltip = __("In this field, you would be able to see start date of Login Logs", "wp-captcha-booster");
      $cpb_recent_login_logs_end_date_tooltip = __("In this field, you would be able to see end date of Login Logs", "wp-captcha-booster");
      $cpb_live_traffic_start_date_tooltip = __("In this field, you would be able to see start date of Visitor Logs", "wp-captcha-booster");
      $cpb_live_traffic_end_date_tooltip = __("In this field, you would be able to see end date of Visitor Logs", "wp-captcha-booster");
      $cpb_live_traffic_monitoring_message = __("Live Traffic Monitoring is Turned Off. Please go to General Setiings > Other Settings Menu to enable it", "wp-captcha-booster");
      $cpb_recent_login_on_world_map = __("Login Logs On World Map", "wp-captcha-booster");
      $cpb_live_traffic_on_world_map = __("Live Traffic On World Map", "wp-captcha-booster");
      $cpb_visitor_logs_on_world_map = __("Visitor Logs On World Map", "wp-captcha-booster");
      $cpb_visitor_logs_monitoring_message = __("Visitor Logs Monitoring is Turned Off. Please go to General Setiings > Other Settings Menu to enable it", "wp-captcha-booster");
      $cpb_details = __("Details", "wp-captcha-booster");
      $cpb_status = __("Status", "wp-captcha-booster");

      //error messages
      $cpb_error_message_login_failure_title = __("For Maximum Login Attempts Error Message", "wp-captcha-booster");
      $cpb_error_message_login_failure_tooltip = __("in this field, you would need to provide an error message to be displayed when a user exceeds maximum number of login attempts", "wp-captcha-booster");
      $cpb_error_message_login_failure_placeholder = __("Please provide Login Attempts Error Message", "wp-captcha-booster");
      $cpb_error_message_invalid_captcha_title = __("For Invalid Captcha Error Message", "wp-captcha-booster");
      $cpb_error_message_invalid_captcha_tooltip = __("In this field, you would need to provide an error message to be displayed when an Invalid captcha is provided by a user", "wp-captcha-booster");
      $cpb_error_message_invalid_captcha_placeholder = __("Please provide Invalid Captcha Error Message", "wp-captcha-booster");
      $cpb_error_message_blocked_ip_address_title = __("For Blocked IP Address Error Message", "wp-captcha-booster");
      $cpb_error_message_blocked_ip_address_tooltip = __("In this field, you would need to provide an error message to be displayed when a user IP Address is blocked", "wp-captcha-booster");
      $cpb_error_message_blocked_ip_address_placeholder = __("Please provide Blocked IP Address Error Message", "wp-captcha-booster");
      $cpb_error_message_empty_captcha_title = __("For Captcha Empty Error Message", "wp-captcha-booster");
      $cpb_error_message_empty_captcha_tooltip = __("In this field, you would need to provide an error message to be displayed when the captcha is empty", "wp-captcha-booster");
      $cpb_error_message_empty_captcha_placeholder = __("Please provide Empty Captcha Error Message", "wp-captcha-booster");
      $cpb_error_message_blocked_ip_range_title = __("For Blocked IP Range Error Message", "wp-captcha-booster");
      $cpb_error_message_blocked_ip_range_tooltip = __("In this field, you would need to provide an error message to be displayed when a user IP Range is blocked", "wp-captcha-booster");
      $cpb_error_message_blocked_ip_range_placeholder = __("Please provide Blocked IP Range Error Message", "wp-captcha-booster");
      $cpb_error_messages_blocked_country_label = __("For Blocked Country Error Message", "wp-captcha-booster");
      $cpb_error_messages_blocked_country_tooltip = __("In this field, you would need to provide an error message to be displayed when a user country is blocked", "wp-captcha-booster");
      $cpb_error_messages_blocked_country_placeholder = __("Please provide your Blocked Country Error Message", "wp-captcha-booster");

      // Display settings
      $cpb_display_settings_enable_captcha_for = __("Enable Captcha For", "wp-captcha-booster");
      $cpb_display_settings_enable_captcha_tooltip = __("If you would like to use Captcha on your form then you would need to choose at particular Check Box to display a captcha on required forms", "wp-captcha-booster");
      $cpb_display_settings_login_form = __("WordPress Login Form", "wp-captcha-booster");
      $cpb_display_settings_registration_form = __("WordPress Registration Form", "wp-captcha-booster");
      $cpb_display_settings_reset_password_form = __("WordPress Reset Password Form", "wp-captcha-booster");
      $cpb_display_settings_comment_form = __("WordPress Comment Form", "wp-captcha-booster");
      $cpb_display_settings_admin_comment_form = __("WordPress Admin Comment Form", "wp-captcha-booster");
      $cpb_display_settings_hide_captcha_register_user = __("WordPress Hide Captcha For Registered user", "wp-captcha-booster");
      $cpb_display_settings_captcha_woocommerce_login = __("WooCommerce Login Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_woocommerce_register = __("WooCommerce Registration Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_woocommerce_lost_password = __("WooCommerce Reset Password Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_woocommerce_checkout = __("WooCommerce Checkout Form", "wp-captcha-booster");
      $cpb_display_settings_contact_form7 = __("Contact Form 7", "wp-captcha-booster");
      $cpb_display_settings_buddypress = __("BuddyPress Registration Form", "wp-captcha-booster");
      $cpb_display_settings_buddypress_login = __("BuddyPress Login Form", "wp-captcha-booster");
      $cpb_display_settings_buddypress_lost_password = __("BuddyPress Reset Password Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_shortcode = __("Please copy and paste this shortcode in your Contact Form after Saving Changes", "wp-captcha-booster");
      $cpb_display_settings_captcha_bbpress_login = __("bbPress Login Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_bbpress_register = __("bbPress Registration Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_bbpress_lost_password = __("bbPress Reset Password Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_bbpress_new_topic = __("bbPress New Topic Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_bbpress_reply_topic = __("bbPress Reply To Topic Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_wpforo_login = __("wpForo Login Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_wpforo_register = __("wpForo Registration Form", "wp-captcha-booster");
      $cpb_display_settings_captcha_jetpack_form = __("Jetpack Contact Form", "wp-captcha-booster");

      //Blocking Options
      $cpb_blocking_options_title = __("Auto IP Block", "wp-captcha-booster");
      $cpb_blocking_options_tooltip = __("In this field, you would need to choose Enable to automatically block an IP Address when a user exceeds their maximum login attempts", "wp-captcha-booster");
      $cpb_blocking_options_login_attempts_title = __("Maximum Login Attempts in a Day", "wp-captcha-booster");
      $cpb_blocking_options_login_attempts_tooltip = __("In this field, you would need to provide the maximum number of login attempts in a day. If a user exceeds its login attempts, then their IP Address will be automatically blocked", "wp-captcha-booster");
      $cpb_blocking_options_login_attempts_placeholder = __("Please provide Maximum Login Attempts", "wp-captcha-booster");

      //Manage IP Addresses
      $cpb_manage_ip_addresses_tooltip = __("In this field, you would need to provide a valid IP Address which you would like to block, so that  blocked user will not be able to access website", "wp-captcha-booster");
      $cpb_manage_ip_addresses_View_block = __("View Blocked IP Addresses", "wp-captcha-booster");
      $cpb_manage_ip_addresses_tooltip_start_date = __("In this field, you would need to provide start date of Blocked IP Addresses", "wp-captcha-booster");
      $cpb_manage_ip_addresses_tooltip_end_date = __("In this field, you would need to provide end date of Blocked IP Addresses", "wp-captcha-booster");
      $cpb_tooltip_comment = __(" In this field, you would need to provide comments regarding the reason for blocking this IP Address", "wp-captcha-booster");

      //Manage IP Ranges
      $cpb_manage_ip_ranges_start_range_title = __("Start IP Range", "wp-captcha-booster");
      $cpb_manage_ip_ranges_start_range_tooltip = __("In this field, you would need to provide a valid Start IP Ranges which you would like to block", "wp-captcha-booster");
      $cpb_manage_ip_ranges_start_range_placeholder = __("Please provide Start IP Range", "wp-captcha-booster");
      $cpb_manage_ip_ranges_end_range_title = __("End IP Range", "wp-captcha-booster");
      $cpb_manage_ip_ranges_end_range_tooltip = __("In this field, you would need to provide a valid End IP Ranges which you would like to block", "wp-captcha-booster");
      $cpb_manage_ip_ranges_end_range_placeholder = __("Please provide End IP Range", "wp-captcha-booster");
      $cpb_manage_ip_ranges_block_tooltip = __("In this field, you would need to choose a time duration for which you would like to block IP Ranges", "wp-captcha-booster");
      $cpb_manage_ip_ranges_comment = __("In this field, you would need to provide comments regarding the reason for blocking this IP Ranges", "wp-captcha-booster");
      $cbp_manage_ip_ranges_block = __("Block IP Range", "wp-captcha-booster");
      $cpb_manage_ip_ranges_view_block = __("View Blocked IP Ranges", "wp-captcha-booster");
      $cpb_manage_ip_ranges_start_date_tooltip = __("In this field, you would need to provide start date of Blocked IP Range", "wp-captcha-booster");
      $cpb_manage_ip_ranges_end_date_tooltip = __("In this field, you would need to provide end date of Blocked IP Range", "wp-captcha-booster");

      //Common Variables
      $mb_upgrade_to = __("Upgrade to Premium Editions", "wp-mail-bank");
      $cpb_color_code = __("Please provide Color Code", "wp-captcha-booster");
      $cpb_block_for_title = __("Blocked For", "wp-captcha-booster");
      $cpb_block_for_tooltip = __("In this field, you would need to choose a time duration for which you would like to block IP Address", "wp-captcha-booster");
      $cpb_one_hour = __("1 Hour", "wp-captcha-booster");
      $cpb_twelve_hours = __("12 Hours", "wp-captcha-booster");
      $cpb_twenty_four_hours = __("24 Hours", "wp-captcha-booster");
      $cpb_forty_eight_hours = __("48 Hours", "wp-captcha-booster");
      $cpb_one_week = __("1 Week", "wp-captcha-booster");
      $cpb_one_month = __("1 Month", "wp-captcha-booster");
      $cpb_permanently = __("Permanently", "wp-captcha-booster");
      $cpb_never = __("Never", "wp-captcha-booster");
      $cpb_button_clear = __("Clear", "wp-captcha-booster");
      $cpb_comments = __("Comments", "wp-captcha-booster");
      $cpb_placeholder_comment = __("Please provide Comments", "wp-captcha-booster");
      $cpb_start_date_heading = __("Start Date", "wp-captcha-booster");
      $cpb_end_date_heading = __("End Date", "wp-captcha-booster");
      $cpb_bulk_action = __("Bulk Action", "wp-captcha-booster");
      $cpb_apply = __("Apply", "wp-captcha-booster");
      $cpb_manage_ip_ranges = __("Manage IP Ranges", "wp-captcha-booster");
      $cpb_blocking_options = __("Blocking Options", "wp-captcha-booster");
      $cpb_manage_ip_addresses = __("Manage IP Addresses", "wp-captcha-booster");
      $cpb_submit = __("Submit", "wp-captcha-booster");
      $cpb_resources = __("Resources", "wp-captcha-booster");
      $cpb_http_user_agent = __("HTTP User Agent", "wp-captcha-booster");
      $cpb_error_message_common = __("Error Messages", "wp-captcha-booster");
      $cpb_live_traffic_title = __("Live Traffic", "wp-captcha-booster");
      $cpb_visitor_logs_title = __("Visitor Logs", "wp-captcha-booster");
      $cpb_recent_login_log_title = __("Login Logs", "wp-captcha-booster");
      $cpb_delete = __("Delete", "wp-captcha-booster");
      $cpb_block_ip_address = __("Block IP Address", "wp-captcha-booster");
      $cpb_start_date_placeholder = __("Please provide Start Date", "wp-captcha-booster");
      $cpb_end_date_placeholder = __("Please provide End Date", "wp-captcha-booster");
      $cpb_captcha_setup_menu = __("Captcha Setup", "wp-captcha-booster");
      $cpb_alert_setup_menu = __("Alert Setup", "wp-captcha-booster");
      $cpb_logs_menu = __("Logs", "wp-captcha-booster");
      $cpb_advance_security_menu = __("Advance Security", "wp-captcha-booster");
      $cpb_country_blocks_menu = __("Country Blocks", "wp-captcha-booster");
      $cpb_email_templates_menu = __("Email Templates", "wp-captcha-booster");
      $cpb_other_settings_menu = __("Other Settings", "wp-captcha-booster");
      $cpb_roles_and_capabilities_menu = __("Roles & Capabilities", "wp-captcha-booster");
      $cpb_system_information_menu = __("System Information", "wp-captcha-booster");
      $cpb_roles_and_capabilities_full_control = __("Full Control", "wp-captcha-booster");
      $cpb_captcha_booster_breadcrumb = __("Captcha Booster", "wp-captcha-booster");
      $cpb_captcha_booster_type_breadcrumb = __("Captcha Type", "wp-captcha-booster");
      $cpb_display_settings_title = __("Display Settings", "wp-captcha-booster");
      $cpb_ip_ranges = __("IP Ranges", "wp-captcha-booster");
      $cpb_enable = __("Enable", "wp-captcha-booster");
      $cpb_disable = __("Disable", "wp-captcha-booster");
      $cpb_save_changes = __("Save Changes", "wp-captcha-booster");
      $cpb_email_subject_title = __("Subject", "wp-captcha-booster");
      $cpb_placeholder_subject = __("Please provide Subject", "wp-captcha-booster");
      $cpb_block_time = __("Blocked Date & Time", "wp-captcha-booster");
      $cpb_release_time = __("Release Date & Time", "wp-captcha-booster");
      $cpb_user_name = __("User Name", "wp-captcha-booster");
      $cpb_date_time = __("Date & Time", "wp-captcha-booster");
      $cpb_action = __("Action", "wp-captcha-booster");
      $cpb_user_access_message = __("You don't have Sufficient Access to this Page. Kindly contact the Administrator for more Privileges", "wp-captcha-booster");
      $cpb_general_settings_menu = __("General Settings", "wp-captcha-booster");
      $cpb_advance_country_block = __("Country Blocks", "wp-captcha-booster");
      $cpb_advance_security_label = __("Advance Security", "wp-captcha-booster");
      $cpb_upgrade = __("Premium Editions", "wp-captcha-booster");
      $cpb_premium = __("Premium Edition", "wp-captcha-booster");

      //country Blocks
      $cpb_country_blocks_available_countries_label = __("Available Countries", "wp-captcha-booster");
      $cpb_country_blocks_available_countries_tooltip = __("List of all Countries", "wp-captcha-booster");
      $cpb_country_blocks_add_button_label = __("Add >>", "wp-captcha-booster");
      $cpb_country_blocks_remove_button_label = __("<< Remove", "wp-captcha-booster");
      $cpb_country_blocks_blocked_countries_label = __("Blocked Countries", "wp-captcha-booster");
      $cpb_country_blocks_blocked_countries_tooltip = __("List of all Countries being Blocked", "wp-captcha-booster");
      $cpb_block = __("Block", "wp-captcha-booster");
   }
}