<?php

/**
 * Class WGM_Sepa_Direct_Debit
 *
 * German Market Gateway SEPA Direct Debit
 *
 * @author MarketPress
 */
class WGM_Sepa_Direct_Debit {

	/**
	 * @var WGM_Sepa_Direct_Debit
	 * @since v3.3
	 */
	private static $instance = null;
	
	/**
	* Singletone get_instance
	*
	* @static
	* @return WGM_Sepa_Direct_Debit
	*/
	public static function get_instance() {
		if ( self::$instance == NULL) {
			self::$instance = new WGM_Sepa_Direct_Debit();	
		}
		return self::$instance;
	}

	/**
	* Singletone constructor
	*
	* @access private
	*/
	private function __construct() {
 		
		if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
			return;
		}
		
		require_once dirname( Woocommerce_German_Market::$plugin_filename ) . '/gateways/WGM_Gateway_Sepa_Direct_Debit.php';
		
		$sdd_settings = get_option( 'woocommerce_german_market_sepa_direct_debit_settings' );

		$costs = $sdd_settings[ 'woocommerce_german_market_sepa_direct_debit_fee' ];
		if ( floatval( str_replace( ',', '.', $costs ) ) > 0.0 ) {
			WGM_Gateways::set_gateway_fee( 'german_market_sepa_direct_debit' , $sdd_settings[ 'woocommerce_german_market_sepa_direct_debit_fee' ] );
		}

		add_filter( 'woocommerce_payment_gateways', array( $this, 'german_market_add_sepa_direct_debit' ) );

		/**
		/* validation of additional checkout fields
		**/
		if ( get_option( 'woocommerce_de_secondcheckout', 'off' ) == 'on' ) {
			add_filter( 'gm_checkout_validation_first_checkout', array( 'WGM_Gateway_Sepa_Direct_Debit', 'validate_required_fields' ) );
		}

		if ( $sdd_settings[ 'enabled' ] == 'yes' && $sdd_settings[ 'checkbox_confirmation' ] == 'activated' ) {

			add_filter( 'woocommerce_de_review_order_after_submit', array( 'WGM_Gateway_Sepa_Direct_Debit', 'checkout_field_checkbox' ) );

			if ( get_option( 'woocommerce_de_secondcheckout', 'off' ) == 'on' ) {

		   		add_filter( 'gm_checkout_validation_fields_second_checkout', array( 'WGM_Gateway_Sepa_Direct_Debit', 'checkout_field_checkbox_validation' ) );

		   	} else {

		   		add_filter( 'woocommerce_after_checkout_validation', array( 'WGM_Gateway_Sepa_Direct_Debit', 'checkout_field_checkbox_validation' ) );

		   	}

		}

		// ajax
		if ( $sdd_settings[ 'enabled' ] == 'yes' ) {
			add_action( 'wp_ajax_gm_sepa_direct_debit_mandate_preview', 		array( $this, 'ajax_mandate_preview' ) );
			add_action( 'wp_ajax_nopriv_gm_sepa_direct_debit_mandate_preview', 	array( $this, 'ajax_mandate_preview' ) );
		}
		
		if ( is_admin() ) {
			add_action( 'current_screen', array( $this, 'load_gateway_on_shop_order' ) );
		}

		// backend download
		add_action( 'wp_ajax_german_market_download_sepa_mandate', array( $this, 'admin_ajax_download_pdf' ) );
		
	}

	/**
	* Load Gateway on shop order screen
	*
	* @wp-hook current_screen
	* @return void
	**/
	public function load_gateway_on_shop_order() {

		$screen = get_current_screen();

		if ( $screen->id == 'edit-shop_order' || $screen->id == 'shop_order' ) {
			if ( WGM_Gateway_Sepa_Direct_Debit::$instances == 0 ) {
				$new_gateway = new WGM_Gateway_Sepa_Direct_Debit();
			}
		}
	}

	/**
	* Ajax
	*
	* @since GM 3.3
	* @wp-hook wp_ajax_gm_sepa_direct_debit_mandate_preview
	* @return void
	**/
	public function ajax_mandate_preview() {
		
		if ( ! ( isset( $_REQUEST[ 'nonce' ] ) && wp_verify_nonce( $_REQUEST[ 'nonce' ], 'gm-sepa-direct-debit' ) ) ) {

			echo __( 'There was an error generating the mandate preview. Please reload the page and try again', 'woocommerce-german-market' );

		} else {

			unset( $_REQUEST[ 'nonce' ] );

			// close button
			?><div class="close"><?php echo apply_filters( 'german_market_sepa_close_mandate_preview', __( 'Close', 'woocommerce-german-market' ) ); ?></div><?php

			// mandate text
			echo '<div class="gm-sepa-mandate-preview-inner">' . self::generatre_mandate_preview( $_REQUEST ) . '</div>';

		}

		exit();
	}

	/**
	* Get Ajax preview
	*
	* @since GM 3.3
	* @param Array $args
	* @return String
	**/
	public static function generatre_mandate_preview( $args, $mandate_id = false, $date = false ) {

		$sdd_settings = get_option( 'woocommerce_german_market_sepa_direct_debit_settings' );

		$mandate_text = $sdd_settings[ 'direct_debit_mandate' ];

		$search = array(
			'[creditor_information]',
			'[creditor_identifier]',
			'[creditor_account_holder]',
			'[creditor_iban]',
			'[creditor_bic]',
			'[mandate_id]',
			'[street]',
			'[city]',
			'[postcode]',
			'[country]',
			'[date]',
			'[account_holder]',
			'[account_iban]',
			'[account_bic]',
			'[amount]'
		);

		
		if ( ! isset( $args[ 'amount' ] ) ) {
			$amount = WC()->cart->get_total();
		} else {
			$amount = $args[ 'amount' ];
		}

		$replace = array(
			$sdd_settings[ 'creditor_information' ],
			$sdd_settings[ 'creditor_identifier' ],
			$sdd_settings[ 'creditor_account_holder' ],
			$sdd_settings[ 'iban' ],
			$sdd_settings[ 'bic' ],
			$mandate_id ? $mandate_id : __( 'Will be communicated separately', 'woocommerce-german-market' ),
			$args[ 'street' ],
			$args[ 'city' ],
			$args[ 'zip' ],
			$args[ 'country' ],
			$date ? $date :  date_i18n( get_option( 'date_format' ), time() ),
			$args[ 'holder' ],
			$args[ 'iban' ],
			$args[ 'bic' ],
			$amount,
		);

		$mandate_preview = apply_filters( 'the_content', str_replace( $search, $replace, $mandate_text ) );

		return $mandate_preview;

	}

	/**
	* Add Gateway
	*
	* @since GM 3.3
	* @wp-hook woocommerce_payment_gateways
	* @param Array $gateway
	* @return Array
	**/
	public function german_market_add_sepa_direct_debit( $gateways ) {
		$gateways[] = 'WGM_Gateway_Sepa_Direct_Debit';
		return $gateways;
	}

	/**
	* ajax, manages what happen when the downloadbutton on admin order page is clicked
	*
	* @since WGM 3.0
	* @access public
	* @static 
	* @hook wp_ajax_german_market_download_sepa_mandate
	* @arguments $_REQUEST[ 'order_id' ]
	* @return void, exit()
	*/	
	public static function admin_ajax_download_pdf() {
		
		if ( ! check_ajax_referer( 'german-market-sepa-mandate', 'security', false ) ) {
			wp_die( __( 'You have taken too long. Please go back and retry.', 'woocommerce-german-market' ), '', array( 'response' => 403 ) );
		}

		 // load invoice pdf class if add-on is deactivated
		if ( ! class_exists( 'Woocommerce_Invoice_Pdf' ) ) {

            include_once( WGM_ADD_ONS_PATH . DIRECTORY_SEPARATOR . 'woocommerce-invoice-pdf' . DIRECTORY_SEPARATOR . 'woocommerce-invoice-pdf.php' );

            // maybe load default pdf settings
            if ( get_option( 'wp_wc_invoice_pdf_document_title', false ) === false ) {
                WP_WC_Invoice_Pdf_Backend_Activation::load_defaults();
            }

        }
					
		$order_id	= $_REQUEST[ 'order_id' ];
		$order 		= new WC_Order( $order_id );
		//self::order_action( $order );

		$args = array(
            'street'    			=> $_REQUEST[ 'street' ],
            'city'      			=> $_REQUEST[ 'city' ],
            'zip'       			=> $_REQUEST[ 'zip' ],
            'country'   			=> $_REQUEST[ 'country' ],
            'holder'    			=> $_REQUEST[ 'holder' ],
            'iban'      			=> $_REQUEST[ 'iban' ],
            'bic'      				=> $_REQUEST[ 'bic' ],
            'mandate_id'			=> $_REQUEST[ 'mandate_id' ],
            'date'					=> $_REQUEST[ 'date' ],
            'email_admin_iban_mask'	=> $_REQUEST[ 'email_admin_iban_mask' ],
            'iban'					=> $_REQUEST[ 'iban' ],
            'amount'				=> wc_price( $order->get_total() ),
        );

		if ( $args[ 'email_admin_iban_mask' ] == 'off' ) {
			$args[ 'iban' ] = $_REQUEST[ 'unmasked_iban' ];
		}

		add_filter( 'wp_wc_invoice_pdf_template_invoice_content', array( 'WGM_Sepa_Direct_Debit', 'pdf_content' ) );
        $args = array(
            'order'             => $order,
            'output_format'     => 'pdf',
            'output'            => '',
            'filename'          => __( 'SEPA Mandate', 'woocommerce-german-market' ) . ' ' . __( 'for order', 'woocommerce-german-market' ) . ' ' . $order_id,
            'sepa_args'         => $args,
        );
        $sepa_pdf              = new WP_WC_Invoice_Pdf_Create_Pdf( $args );
        remove_filter( 'wp_wc_invoice_pdf_template_invoice_content',  array( 'WGM_Sepa_Direct_Debit', 'pdf_content' ) );

		exit();
	}

	/**
    * template for sepa mandate in pdf
    *
    * @hook wp_wc_invoice_pdf_template_invoice_content
    * @param String $path
    * @return String
    */
    public static function pdf_content() {

        $theme_template_file = get_stylesheet_directory() . DIRECTORY_SEPARATOR . 'woocommerce-invoice-pdf' . DIRECTORY_SEPARATOR . 'sepa-mandate.php';
        if ( file_exists( $theme_template_file ) ) {
            $template_path = $theme_template_file;
        } else {
            $template_path = untrailingslashit( plugin_dir_path( Woocommerce_Invoice_Pdf::$plugin_filename ) ) . DIRECTORY_SEPARATOR . 'vendors' . DIRECTORY_SEPARATOR . 'self' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . 'sepa-mandate.php';
        }

        return $template_path;

    }


}
