<?php

/**
 * Class WGM_Ui
 *
 * German Market Userinterface
 *
 * @author MarketPress
 */
class WGM_Ui {

	/**
	 * @var WGM_Ui
	 */
	private static $instance = null;

	/**
	 * @var String
	 */
	private $current_screen_id = null;
	
	/**
	* Singletone get_instance
	*
	* @static
	* @return WGM_Ui
	*/
	public static function get_instance() {
		if ( self::$instance == NULL) {
			self::$instance = new WGM_Ui();	
		}
		return self::$instance;
	}

	/**
	* Singletone constructor
	*
	* @access private
	*/
	private function __construct() {
		
		// add submenu
		add_action( 'admin_menu', array( $this, 'add_german_market_submenu' ), 51 );

		// enqueue woocommerce admin styles
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts_and_styles' ) );

		// our checkbox
		add_action( 'woocommerce_admin_field_wgm_ui_checkbox', array( $this, 'wgm_ui_checkbox' ) );

		// save checkbox correct so we can use of WGM <= 3.0
		add_filter( 'woocommerce_admin_settings_sanitize_option', array( $this, 'woocommerce_admin_settings_sanitize_option' ), 10, 3 );

		// let other add actions or remove our actions
		do_action( 'wgm_ui_after_actions', $this );

	}

	/**
	* Add submenu
	* 
	* @wp-hook admin_enqueue_scripts
	* @access public
	* @return void
	*/
	public function enqueue_scripts_and_styles() {
		
		// load only for German Market Backend Menu
		$current_screen = get_current_screen();

		if ( $current_screen->id == $this->current_screen_id ) {
			
			$script_debug = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG;
			$suffix = $script_debug ? '' : '.min';

			wp_enqueue_style( 'woocommerce_admin_styles', WC()->plugin_url() . '/assets/css/admin.css', array(), WC_VERSION );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'woocommerce_settings', WC()->plugin_url() . '/assets/js/admin/settings' . $suffix . '.js', array( 'jquery', 'jquery-ui-datepicker', 'jquery-ui-sortable', 'iris', 'select2' ), WC()->version, true );
			
			// WooCommerce scripts for select2
			wp_register_script( 'select2', WC()->plugin_url() . '/assets/js/select2/select2' . $suffix . '.js', array( 'jquery' ), '3.5.4' );
			wp_register_script( 'wc-enhanced-select', WC()->plugin_url() . '/assets/js/admin/wc-enhanced-select' . $suffix . '.js', array( 'jquery', 'select2' ), WC_VERSION );
			wp_localize_script( 'wc-enhanced-select', 'wc_enhanced_select_params', array(
				'i18n_matches_1'            => _x( 'One result is available, press enter to select it.', 'enhanced select', 'woocommerce' ),
				'i18n_matches_n'            => _x( '%qty% results are available, use up and down arrow keys to navigate.', 'enhanced select', 'woocommerce' ),
				'i18n_no_matches'           => _x( 'No matches found', 'enhanced select', 'woocommerce' ),
				'i18n_ajax_error'           => _x( 'Loading failed', 'enhanced select', 'woocommerce' ),
				'i18n_input_too_short_1'    => _x( 'Please enter 1 or more characters', 'enhanced select', 'woocommerce' ),
				'i18n_input_too_short_n'    => _x( 'Please enter %qty% or more characters', 'enhanced select', 'woocommerce' ),
				'i18n_input_too_long_1'     => _x( 'Please delete 1 character', 'enhanced select', 'woocommerce' ),
				'i18n_input_too_long_n'     => _x( 'Please delete %qty% characters', 'enhanced select', 'woocommerce' ),
				'i18n_selection_too_long_1' => _x( 'You can only select 1 item', 'enhanced select', 'woocommerce' ),
				'i18n_selection_too_long_n' => _x( 'You can only select %qty% items', 'enhanced select', 'woocommerce' ),
				'i18n_load_more'            => _x( 'Loading more results&hellip;', 'enhanced select', 'woocommerce' ),
				'i18n_searching'            => _x( 'Searching&hellip;', 'enhanced select', 'woocommerce' ),
				'ajax_url'                  => admin_url( 'admin-ajax.php' ),
				'search_products_nonce'     => wp_create_nonce( 'search-products' ),
				'search_customers_nonce'    => wp_create_nonce( 'search-customers' )
			) );

			wp_enqueue_script( 'wc-enhanced-select' );

			// WooCommerce styles for tool tips
			wp_enqueue_style( 'woocommerce_admin_styles', WC()->plugin_url() . '/assets/css/admin.css', array(), WC_VERSION );

			// Media Uploader
			wp_enqueue_script( 'media-upload' );
			wp_enqueue_script( 'thickbox' );
			wp_enqueue_style( 'thickbox' );

			// German Market styles
			$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : 'min.';
			wp_enqueue_style( 'woocommerce_de_admin', plugins_url( '/css/backend.' . $min . 'css', Woocommerce_German_Market::$plugin_base_name ) );
		}
	}

	/**
	* Add submenu
	* 
	* @wp-hook admin_menu
	* @access public
	*/
	public function add_german_market_submenu() {

		$submenu_page = add_submenu_page( 
			'woocommerce', 
			__( 'German Market', 'woocommerce-german-market' ), 
			__( 'German Market', 'woocommerce-german-market' ),
			apply_filters( 'wgm_ui_capability', 'manage_woocommerce' ),
			'german-market', 
			array( $this, 'render_german_market_menu' )
		);

		$this->current_screen_id = $submenu_page;

	}

	/**
	* Output type wgm_ui_checkbox
	*
	* @access public
	* @hook woocommerce_admin_field_wgm_ui_checkbox
	* @return void
	*/
	public function wgm_ui_checkbox( $value ){
		
		$option_value    = WC_Admin_Settings::get_option( $value['id'], $value['default'] );

		// Description handling
		$field_description = WC_Admin_Settings::get_field_description( $value );
		extract( $field_description );

		$visbility_class = array();

		if ( ! isset( $value['hide_if_checked'] ) ) {
			$value['hide_if_checked'] = false;
		}
		if ( ! isset( $value['show_if_checked'] ) ) {
			$value['show_if_checked'] = false;
		}
		if ( 'yes' == $value['hide_if_checked'] || 'yes' == $value['show_if_checked'] ) {
			$visbility_class[] = 'hidden_option';
		}
		if ( 'option' == $value['hide_if_checked'] ) {
			$visbility_class[] = 'hide_options_if_checked';
		}
		if ( 'option' == $value['show_if_checked'] ) {
			$visbility_class[] = 'show_options_if_checked';
		}

		?>
			<tr valign="top" class="<?php echo esc_attr( implode( ' ', $visbility_class ) ); ?>">
				<th scope="row" class="titledesc"><?php echo esc_html( $value['title'] ) ?><?php echo $tooltip_html; ?></th>
				<td class="forminp forminp-checkbox">
					<fieldset>
		<?php

		if ( ! empty( $value['title'] ) ) {
			?>
				<legend class="screen-reader-text"><span><?php echo esc_html( $value['title'] ) ?></span></legend>
			<?php
		}
		
		?>
			<label class="switch" for="<?php echo $value['id'] ?>">
				<input
					name="<?php echo esc_attr( $value['id'] ); ?>"
					id="<?php echo esc_attr( $value['id'] ); ?>"
					type="checkbox"
					class="<?php echo esc_attr( isset( $value['class'] ) ? $value['class'] : '' ); ?>"
					value="on"
					<?php 
						if ( $value[ 'id' ] == 'wp_wc_invoice_pdf_inline_style' ) {
							checked( $option_value, true ); 
						} else if ( $value[ 'id' ] == 'wp_wc_invoice_pdf_remove_css_style' ) {
							if ( $option_value == 0 || $option_value == '0' ) {
								$option_value = false;
							}
							checked( $option_value, false ); 
						} else if ( $value[ 'id' ] == 'wp_wc_invoice_pdf_force_html_output' ) {
							checked( $option_value, 'yes' ); 
						} else if ( $value[ 'id' ] == 'wp_wc_running_invoice_number_multisite_global' ) {
							checked( $option_value, 'yes' );
						} else {	
							checked( $option_value, 'on' ); 
						}

						if ( isset( $value[ 'custom_attributes' ][ 'disabled' ] ) ) {
							?>disabled<?php
						}
					?>

				/>
				<div class="slider round"></div>

			</label> 
			<?php
				if ( isset( $value[ 'desc' ] ) && $value[ 'desc' ] != '' ) {
					?><br /><span class="description"><?php echo $value[ 'desc' ]; ?></span><?php
				}
			?>
		<?php

		if ( ! isset( $value['checkboxgroup'] ) || 'end' == $value['checkboxgroup'] ) {
						?>
						</fieldset>
					</td>
				</tr>
			<?php
		} else {
			?>
				</fieldset>
			<?php
		}

	}

	/**
	* Save type wgm_ui_checkbox
	*
	* @access public
	* @hook woocommerce_admin_settings_sanitize_option
	* @param Mixed $value
	* @param Array $option
	* @param Mixed $raw_value
	* @return $value
	*/
	public function woocommerce_admin_settings_sanitize_option( $value, $option, $raw_value ) {

		// if it is our checkbox type
		if ( $option[ 'type' ] == 'wgm_ui_checkbox' ) {

			// invoice-pdf => compatible with WGM code <= 3.0
			if ( $option[ 'id' ] == 'wp_wc_invoice_pdf_inline_style' ) {
				$value = is_null( $raw_value ) ? false : true;
			} else if ( $option[ 'id' ] == 'wp_wc_invoice_pdf_remove_css_style' ) {
				$value = is_null( $raw_value ) ? true : false;
			} else if ( $option[ 'id' ] == 'wp_wc_invoice_pdf_force_html_output' ) {
				$value = is_null( $raw_value ) ? 'no' : 'yes';
			} else {
				// save as "on" or "off" to be compatible with WGM code <= 3.0
				$value = is_null( $raw_value ) ? 'off' : 'on';
			}

		}

		return $value;
	}

	/**
	* Get left menu items
	* 
	* @access private
	* @return array
	*/
	private function get_left_menu_items() {

		$german_market = array( 
			'title'		=> __( 'General', 'woocommerce-german-market' ),
			'slug'		=> 'general',
			'submenu'	=> array(

				array(
					'title'		=> __( 'Required Pages', 'woocommerce-german-market' ),
					'slug'		=> 'required-pages',
					'callback'	=> array( $this, 'required_pages' ),
					'options'	=> 'yes'
				),

				array(
					'title'		=> __( 'Revocation Policy', 'woocommerce-german-market' ),
					'slug'		=> 'revocation-policy',
					'callback'	=> array( $this, 'revocation_policy' ),
					'options'	=> 'yes'
				),

				array(
					'title'		=> __( 'Small Trading Exemption', 'woocommerce-german-market' ),
					'slug'		=> 'small-trading-exemption',
					'callback'	=> array( $this, 'small_trading_exemption' ),
					'options'	=> 'yes'
				),

				array(
					'title'		=> __( 'Delivery Times', 'woocommerce-german-market' ),
					'slug'		=> 'delivery-times',
					'callback'	=> array( $this, 'delivery_times' ),
					'options'	=> 'yes'
				),

				array(
					'title'		=> __( 'Sale Labels', 'woocommerce-german-market' ),
					'slug'		=> 'sale-labels',
					'callback'	=> array( $this, 'sale_labels' ),
					'options'	=> 'yes'
				),

				array(
					'title'		=> __( 'Products', 'woocommerce-german-market' ),
					'slug'		=> 'products',
					'callback'	=> array( $this, 'products' ),
					'options'	=> 'yes'
				),

				array(
					'title'		=> __( 'Ordering', 'woocommerce-german-market' ),
					'slug'		=> 'cart_and_checkout',
					'callback'	=> array( $this, 'cart_and_checkout' ),
					'options'	=> 'yes'
				),

				array(
					'title'		=> __( 'Global Options', 'woocommerce-german-market' ),
					'slug'		=> 'global',
					'callback'	=> array( $this, 'global_tab' ),
					'options'	=> 'yes'
				),

				array(
					'title'		=> __( 'Emails', 'woocommerce-german-market' ),
					'slug'		=> 'emails',
					'callback'	=> array( $this, 'emails' ),
					'options'	=> 'yes'
				),

			)
		);

		$german_market = apply_filters( 'woocommerce_de_ui_menu_german_market', $german_market );

		$add_ons = array( 
				'title'		=> __( 'Add-ons', 'woocommerce-german-market' ),
				'slug'		=> 'add-ons',
				'new'		=> 'yes',
				'callback'	=> array( $this, 'render_add_ons' )
		);

		$add_ons = apply_filters( 'woocommerce_de_ui_menu_add_ons', $add_ons );

		$items = array(
			0 	=> $german_market,
			500 => $add_ons,
		);

		$items = apply_filters( 'woocommerce_de_ui_left_menu_items', $items );
		ksort( $items );
		return $items;
	}

	/**
	* Add Submenu to WooCommerce Menu
	* 
	* @add_submenu_page
	* @access public
	*/
	public function render_german_market_menu() {

		do_action( 'render_german_market_menu_save_options' );

		?>
		<div class="wrap">

			<div class='german-market'>

				<div class="german-market-left-menu">

					<div class="logo"></div>
                    
                    <div class="mobile-menu-outer">
                        <div class="mobile-menu-button">
                            <div class="txt"><?php echo __( 'Menu', 'woocommerce-german-market' ); ?></div>
                            <div class="mobile-icon">
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                    </div>

					<ul>

						<?php

							$page_url = get_admin_url() . 'admin.php?page=german-market';

							$left_menu_items = $this->get_left_menu_items();
							
							$i = 0;
							
							foreach ( $left_menu_items as $item ) {
								
								$i++;
								
								$classes = array();

								// slug
								$classes[] = $item[ 'slug' ];

								// current tab
								if ( isset ( $_GET[ 'tab' ] ) ) {
									
									if ( $_GET[ 'tab' ] == $item[ 'slug' ] ) {
										$classes[] = 'current';
										$current = $item;
									}

								} else {

									if ( $i == 1 ) {
										$classes[] = 'current'; // if tab is not set, first item is current
										$current = $item;
									}

								}

								// new
								if ( isset( $item[ 'new' ] ) && $item[ 'new' ] ) {
									$classes[] = 'new';
								}

								// info
								if ( isset( $item[ 'info' ] ) && $item[ 'info' ] ) {
									$classes[] = 'info';
								}

								$classes = apply_filters( 'woocommerce_de_ui_left_menu_item_class', $classes, $item );
								$class_string = implode( ' ', $classes );

								?><li class="<?php echo $class_string; ?>"><a href="<?php echo $page_url . '&tab=' . $item[ 'slug' ]; ?>" title="<?php echo esc_attr( $item[ 'title' ] ); ?>"><?php echo $item[ 'title' ];?></a></li><?php

							}
						?>

					</ul>

					<div class="german-market-footer-menu">
						<?php echo __( sprintf( 'Version %s', Woocommerce_German_Market::$version ), 'woocommerce-german-market' );?>
					</div>

				</div>

				<div class="german-market-main-menu">

					<?php $this->render_content( $current ); ?>

				</div>

			</div>

		</div>
		<?php
	}

	/**
	* Render German Market Tab
	* 
	* @access private
	* @return array
	*/
	private function render_content( $item ) {

		$callback = isset( $item[ 'callback' ] ) ? $item[ 'callback' ] : '';
		$page_url = get_admin_url() . 'admin.php?page=german-market&tab=' . $item[ 'slug' ];
		$current  = $item;

		?><h1><?php echo $item[ 'title' ]; ?></h1><?php

		do_action( 'woocommerce_de_ui_after_title', $item );

		// submenu
		if ( isset( $item[ 'submenu' ] ) ) {

			$submenu = $item[ 'submenu' ];
			$classes = array();

			?><ul class="submenu"><?php

				$i=0;

				foreach ( $submenu as $sub_item ) {
					
					$i++;
					
					$classes = array();

					// current sub tab
					if ( isset ( $_GET[ 'sub_tab' ] ) ) {
						
						if ( $_GET[ 'sub_tab' ] == $sub_item[ 'slug' ] ) {
							$classes[]	= 'current';
							$current 	= $sub_item;
							$callback	= isset( $sub_item[ 'callback' ] ) ? $sub_item[ 'callback' ] : $callback;
						}

					} else {

						if ( $i == 1 ) {
							$classes[] = 'current'; // if tab is not set, first item is current
							$current 	= $sub_item;
							$callback	= isset( $sub_item[ 'callback' ] ) ? $sub_item[ 'callback' ] : $callback;
						}

					}

					$classes = apply_filters( 'woocommerce_de_ui_sub_menu_item_class', $classes, $sub_item );
					$class_string = implode( ' ', $classes );
					?><li class="<?php echo $class_string; ?>"><a href="<?php echo $page_url . '&sub_tab=' . $sub_item[ 'slug' ]; ?>" title="<?php echo esc_attr( $sub_item[ 'title' ] ); ?>"><?php echo $sub_item[ 'title' ];?></a></li><?php

				}

			?></ul><?php

			do_action( 'woocommerce_de_ui_after_submenu', $item );

		}

		do_action( 'woocommerce_de_ui_before_callback', $callback );

		$is_option_page = isset( $current[ 'options' ] );

		// callback
		if ( isset( $callback ) ) {
			
			if ( ( is_array( $callback ) && method_exists( $callback[ 0 ], $callback[ 1 ] ) ) || ( ! ( is_array( $callback )  ) && function_exists( $callback ) ) ) {
				
				if ( $is_option_page ) {
					
					$options = call_user_func( $callback );
					
					// save settings
					if ( isset( $_POST[ 'submit_save_wgm_options' ] ) ) {

						if ( ! wp_verify_nonce( $_POST[ 'update_wgm_settings' ], 'woocommerce_de_update_wgm_settings' ) ) {

							?>
							<div class="notice-wgm notice-error">
						        <p><?php echo __( 'Sorry, but something went wrong while saving your settings. Please, try again.', 'woocommerce-german-market' ); ?></p>
						    </div>
						    <?php

						} else {

							woocommerce_update_options( $options );

							do_action( 'woocommerce_de_ui_update_options', $options );

							?>
							<div class="notice-wgm notice-success">
						        <p><?php echo __( 'Your settings have been saved.', 'woocommerce-german-market' ); ?></p>
						    </div>
						    <?php

						}

					}

					?><form method="post"><?php

						$this->save_button( 'top' );

						wp_nonce_field( 'woocommerce_de_update_wgm_settings', 'update_wgm_settings' );
						woocommerce_admin_fields( $options );

						$this->save_button( 'bottom' );

					?></form><?php

				
				} else {
					call_user_func( $callback );
				}
			
			}

		}

		do_action( 'woocommerce_de_ui_after_callback', $callback );
			
	}

	/**
	* Render Options for required pages
	* 
	* @access public
	* @return void
	*/
	public function required_pages() {

		$pages_link          = sprintf(
			'<a href="%s">%s</a>',
			admin_url( 'edit.php?post_type=page' ),
			__( 'Pages' )
		);

		$options = array(

			/**
			 * Required Pages
			 */
			array(
				'name' => __( 'Required Pages', 'woocommerce-german-market' ),
				'type' => 'title',
				'desc' => sprintf(
				/* translators: %s = link to Pages admin section */
					__( 'Some of the following pages are mandatory, some recommended, for online stores based in Germany or Austria. Assign one of your already existing pages to each option. If you haven’t created said pages during activation of WooCommerce German Market, go to %s and create them now. Text templates can be found in the plugin folder of your WordPress installation at <code>woocommerce-german-market/text-templates</code>.<br /><br /><strong>Disclaimer:</strong> You can use those templates, but you <em>must</em> still customize them to fit the individual case of your online business. In your own best interest, consult a legal adviser and have them check your store before you open it to the public. Legal compliance of your online business is your sole responsibility.',
					    'woocommerce-german-market' ),
					$pages_link
				),
				'id'   => 'de_pages',
			),

			/* Page: Legal Information */
			array(
				/* translators: title or link text for a page displaying mandatory legal information, e.g. “Impressum” in German. */
				'name'     => __( 'Legal Information', 'woocommerce-german-market' ),
				'desc'     => '<br />' . __( 'Mandatory legal business information.', 'woocommerce-german-market' ) . ' ' . __( 'The Legal Information page mandatory for any business based in Germany or Austria must contain: company name, CEO, (summonable) company address, phone, fax (if available), website URL, email address, name of finance authority in charge, tax number, VAT Ident Number (VATIN), court in charge, German HRB number (if applicable), bank account owner, bank account number, bank code, bank name, SWIFT, IBAN.<br /><strong>Please note:</strong> For certain occupational category, e.g. pharmacists, architects, lawyers and opticians, additonal business information may be required. Those can vary depending on profession. Consult a legal adviser to make sure about which pieces of information are required for your particular business.',
				                  'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'impressum' ),
				'type'     => 'single_select_page',
				'class'    => 'wc-enhanced-select-nostd',
			),

			/* Page: Shipping & Delivery */
			array(
				'name'     => __( 'Shipping & Delivery', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Mandatory customer information regarding shipping and delivery.',
				                  'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'versandkosten__lieferung' ),
				'type'     => 'single_select_page',
				'class'    => 'wc-enhanced-select-nostd',
			),

			/* Page: Privacy */
			array(
				'name'     => __( 'Privacy', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Mandatory customer information regarding privacy and data security on your site.',
				                  'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'datenschutz' ),
				'type'     => 'single_select_page',
				'class'    => 'wc-enhanced-select-nostd',
			),

			/* Page: Payment Methods */
			array(
				'name'     => __( 'Payment Methods', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Mandatory customer information regarding payment methods offered on your site.',
				                  'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'zahlungsarten' ),
				'type'     => 'single_select_page',
				'class'    => 'wc-enhanced-select-nostd',
			),

			/* Page: Confirm & Place Order */
			array(
				'name'     => __( 'Confirm & Place Order', 'woocommerce-german-market' ),
				'desc_tip'     => __( 'Mandatory second checkout page where customers confirm and finally send their order.', 'woocommerce-german-market' ) . ' ' . __( 'This must be a child page of your Checkout page. It must contain the [woocommerce_de_check] shortcode.', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'check' ),
				'type'     => 'single_select_page',
				'class'    => 'wc-enhanced-select-nostd',
			),

			/* Customer Notice */
			array(
				'name'              => __( 'Customer Notice on Confirm & Place Order Page',
				                           'woocommerce-german-market' ),
				'desc_tip'          => __( 'Provide a final notice for your customers (e.g. regarding customs, fees etc.) before they place their order.', 'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: before order review table on Confirm & Place Order page.', 'woocommerce-german-market' ),
				'id'                => 'woocommerce_de_last_checkout_hints',
				'type'              => 'textarea',
				'custom_attributes' => array( 'rows' => '10', 'cols' => '80' ),
				'default'           => '',
				'args'              => ''
			),

			array( 'type' => 'sectionend', 'id' => 'de_pages' )
		);
		
		$options = apply_filters( 'woocommerce_de_ui_options_required_pages', $options );
		return $options;

	}

	/**
	* Render Options for revocation policy
	* 
	* @access public
	* @return void
	*/
	public function revocation_policy() {

		$options = array(

			/**
			 * Revocation
			 */
			array(
				'name' => __( 'Revocation Policy', 'woocommerce-german-market' ),
				'type' => 'title',
				'desc' => __( 'Enter details regarding your revocation policy.', 'woocommerce-german-market' ),
				'id'   => 'de_widerruf'
			),

			/* Revocation Period */
			array(
				'name'     => __( 'Revocation Period', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Enter a number of days as revocation period. Default: 14 days.', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'widerrufsfrist' ),
				'type'     => 'number',
				'default'  => '14'
			),

			/* Revocation Address */
			array(
				'name'              => __( 'Revocation Address', 'woocommerce-german-market' ),
				'desc_tip'              => __( 'Legal name and summonable (i.e. a physical) address of your company. (P.O. box won’t do!).', 'woocommerce-german-market' ) . ' ' . __( 'Enter your legal company address. New lines will be parsed as line breaks.', 'woocommerce-german-market' ),
				'id'                => WGM_Helper::get_wgm_option( 'widerrufsadressdaten' ),
				'custom_attributes' => array( 'rows' => '10', 'cols' => '80' ),
				'type'              => 'textarea',
				'default'           => ''
			),

			/* Page: Revocation Policy */
			array(
				'name'     => __( 'Revocation Policy', 'woocommerce-german-market' ),
				'desc'     => '<br />' . __( 'Mandatory customer information regarding rights of revocation.', 'woocommerce-german-market' ) . ' ' . __( 'On your Revocation Policy page use the following shortcodes to display the field values you have defined above: [woocommerce_de_disclaimer_deadline] as a placeholder for Revocation Period and [woocommerce_de_disclaimer_address_data] as a placeholder for Revocation Address.', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'widerruf' ),
				'type'     => 'single_select_page',
				'class'    => 'wc-enhanced-select-nostd',
			),

			/* Page: Revocation Policy */
			array(
				'name'     => __( 'Revocation Policy for Digital Content', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Mandatory customer information regarding rights of revocation for digital content.',
				                  'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'widerruf_fuer_digitale_medien' ),
				'type'     => 'single_select_page',
				'class'    => 'wc-enhanced-select-nostd',
			),

			array( 'type' => 'sectionend', 'id' => 'de_widerruf' )

		);

		$options = apply_filters( 'woocommerce_de_ui_options_revocation_policy', $options );
		return $options;

	}

	/**
	* Render Options for small trading exemption
	* 
	* @access public
	* @return void
	*/
	public function small_trading_exemption() {

		$options = array(

						/**
			 * Small trading exemption
			 */
			array(
				/* translators: the infamous “Kleinunternehmerregelung” */
				'name' => __( 'Small Trading Exemption', 'woocommerce-german-market' ),
				'type' => 'title',
				'desc' => __( 'Small Trading Exemption may apply to micro-businesses according UStG §19 (Germany) or UStG §6 (Austria). You’ll know whether it applies to your business.<br />The option below will simply act as a shortcut to deactivate tax calculations in WooCommerce. If you have set this to yes and will set it to no later on, you will have to re-enable tax calcualtion manually.',
				              'woocommerce-german-market' ),
				'id'   => 'de_kleinunternehmerregelung'
			),

			/* Disable Tax Calculations for STE */
			array(
				'name'     => __( 'Disable Tax Calculations for STE', 'woocommerce-german-market' ),
				'desc'     => '',
				'desc_tip' => __( 'Disable all taxes', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_kleinunternehmerregelung' ),
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			array(
				'name'		=> __( 'Tax notice', 'woocommerce-german-market' ),
				'desc_tip'	=> __( 'The tax notice that is shown in your shop if you activate the Small Trading Exemption', 'woocommerce-german-market' ),
				'desc'		=> '<br />' . __( 'Default for Germany:', 'woocommerce-german-market' ) . ' <i>' . __( 'VAT exempted according to UStG §19', 'woocommerce-german-market' ) . '</i><br />' . __( 'Default for Austria:', 'woocommerce-german-market' ) . ' <i>' .  __( 'VAT exempted according to UStG §6', 'woocommerce-german-market' ) . '</i>',
				'id' 		=> 'gm_small_trading_exemption_notice',
				'type'		=> 'text',
				'default'	=> WGM_Template::get_default_ste_string(),
				'css'		=> 'width: 400px;'
			),

			array( 'type' => 'sectionend', 'id' => 'de_kleinunternehmerregelung' ),
		);

		$options = apply_filters( 'woocommerce_de_ui_options_small_trading_exemption', $options );
		return $options;

	}

	/**
	* Render Options for small delivery_times
	* 
	* @access public
	* @return void
	*/
	public function delivery_times() {

		$lieferzeit_strings = WGM_Defaults::get_term_strings( 'product_delivery_times' );

		$delivery_times_link = sprintf(
			'<a href="%s">%s</a>',
			admin_url( 'edit-tags.php?taxonomy=product_delivery_times&post_type=product' ),
			/* translators: link text for Delivery Times admin page */
			__( 'Products → Delivery Times', 'woocommerce-german-market' )
		);

		$options = array(

			/**
			 * Delivery Times
			 */
			array(
				'name' => __( 'Delivery Times', 'woocommerce-german-market' ),
				'type' => 'title',
				'desc' => sprintf(
				/* translators: %s = link to Products → Delivery Times */
					__( 'Delivery times can be configured in %s. Once you have customized yours, set a default delivery time for new products here.',
					    'woocommerce-german-market' ),
					$delivery_times_link
				),
				'id'   => 'de_lieferzeiten'
			),

			/* Default Delivery Times */
			array(
				'name'     => __( 'Default Delivery Time', 'woocommerce-german-market' ),
				'desc_tip'     => __( 'Default delivery time for new products', 'woocommerce-german-market' ) . ' ' . __( 'This value can be overwritten for each product', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'global_lieferzeit' ),
				'type'     => 'select',
				'default'  => 7,
				'options'  => $lieferzeit_strings
			),
			/* Loop: Delivery Times */
			array(
				'name'     => __( 'Show Delivery Times in Shop', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Displays a product’s delivery time on product loop pages.', 'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: below add-to-cart button.', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_show_delivery_time_overview' ),
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			/* Product: Delivery Times */
			array(
				'name'     => __( 'Show Delivery Times on Product Pages', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Displays a product’s delivery time on product pages.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_show_delivery_time_product_page',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on',
			),

			/* Checkout: Delivery Times */
			array(
				'name'     => __( 'Show Delivery Times during Checkout', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Displays a product’s delivery time during checkout.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_show_delivery_time_checkout',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			/* Order summary: Delivery Times */
			array(
				'name'     => __( 'Show Delivery Times on Order Summary', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Displays a product’s delivery time on order summary.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_show_delivery_time_order_summary',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on',
			),

			array( 'type' => 'sectionend', 'id' => 'de_sale_label' ),
		);

		$options = apply_filters( 'woocommerce_de_ui_options_delivery_times', $options );
		return $options;
	}

	/**
	* Render Options for sale_labels
	* 
	* @access public
	* @return void
	*/
	public function sale_labels() {
		
		$sale_label_strings = WGM_Defaults::get_term_strings( 'product_sale_labels' );

		$sale_labels_link    = sprintf(
			'<a href="%s">%s</a>',
			admin_url( 'edit-tags.php?taxonomy=product_sale_labels&post_type=product' ),
			/* translators: link text for Delivery Times admin page */
			__( 'Products → Sale Labels', 'woocommerce-german-market' )
		);

		$options = array(

			/**
			 *  Sale labels
			 */
			array(
				'name' => __( 'Sale Labels', 'woocommerce-german-market' ),
				'type' => 'title',
				'desc' => sprintf(
				/* translators: %s = link to Products → Delivery Times */
					__( 'Sale labels can be configured in %s. Once you have customized yours, set a default sale label for new products here.',
					    'woocommerce-german-market' ),
					$sale_labels_link
				),
				'id'   => 'de_lieferzeiten'
			),

			/* Default Sale Labels */
			array(
				'name'     => __( 'Default Sale Label', 'woocommerce-german-market' ),
				'desc_tip'     => __( 'Default sale label for new products', 'woocommerce-german-market' ) . ' ' .__( 'This value can be overwritten for each product', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'global_sale_label' ),
				'type'     => 'select',
				'default'  => 1,
				'options'  => $sale_label_strings
			),
			
			/* Loop: Sale Labels */
			array(
				'name'     => __( 'Show Sale Labels in Shop', 'woocommerce-german-market' ),
				'desc_tip'     => __( 'Displays a product’s sale label on product loop pages.', 'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: below add-to-cart button.', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_show_sale_label_overview' ),
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			/* Product Page: Sale Labels */
			array(
				'name'     => __( 'Show Sale Labels on Product Pages', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Displays a product’s sale label on product pages.', 'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: below add-to-cart button.','woocommerce-german-market' ),
				'id'       => 'woocommerce_de_show_sale_label_product_page',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			array( 'type' => 'sectionend', 'id' => 'de_lieferzeiten' )

		);

		$options = apply_filters( 'woocommerce_de_ui_options_sale_labels', $options );
		return $options;
	}

	/**
	* Render Options for products
	* 
	* @access public
	* @return void
	*/
	public function products(){

		$options = array();

		/**
		 * Products
		 */
		$options[] = array(
			'name' => _x( 'Products', 'options panel heading', 'woocommerce-german-market' ),
			'type' => 'title',
			'desc' => __( 'The following options apply to the front-end of your online store.', 'woocommerce-german-market' ),
			'id'   => 'de_products'
		);

		/* Loop: PPU */
		$options[] = array(
			'name'     => __( 'Show Price per Unit', 'woocommerce-german-market' ),
			'desc_tip'     => __( 'Displays a product’s price per unit on product loop pages.','woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: below tax line, above shipping link.','woocommerce-german-market' ),
			'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_show_price_per_unit' ),
			'type'     => 'wgm_ui_checkbox',
			'default'  => 'on',
		);

		$options[] = array(
			'name'     => __( 'Show Price per Unit in Checkout & Orders', 'woocommerce-german-market' ),
			'desc_tip'     => __( 'Displays a product’s price per during checkout and in orders.','woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: below tax line, above shipping link.','woocommerce-german-market' ),
			'id'       => 'woocommerce_de_show_ppu_checkout',
			'type'     => 'wgm_ui_checkbox',
			'default'  => 'off',
		);

		/* PPU in Invoice PDF since GM 3.5.2 */
		$is_ppu_checkout_option_on = ( get_option( 'woocommerce_de_show_ppu_checkout', 'off' ) == 'on' );
		if ( isset( $_REQUEST[ 'submit_save_wgm_options' ] ) ) {
			$is_ppu_checkout_option_on = isset( $_REQUEST[ 'woocommerce_de_show_ppu_checkout' ] );
		}

		if ( class_exists( 'Woocommerce_Invoice_Pdf' ) && $is_ppu_checkout_option_on ) {
		
			/* PPU in Invoice PDF since GM 3.5.2 */
			$options[] = array( 
				'name' 		=>__( 'Show Price per Unit in Invoice PDFs', 'woocommerce-german-market' ),
				'desc_tip'  => __( 'Displays a product’s price per unit in Invoice PDFs','woocommerce-german-market' ),
				'id'       => 'woocommerce_de_show_ppu_invoice_pdf',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			);

		}

		/* Single Product: Non-EU Shipping Disclaimer */
		$options[] = array(
			'name'     => __( 'Show Non-EU Shipping Disclaimer', 'woocommerce-german-market' ),
			'desc_tip' => __( 'Adds a disclaimer on single product pages that there may occur additional costs (e.g. customs or taxes) when shipping to non-EU countries.', 'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: below delivery time.', 'woocommerce-german-market' ),
			'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_show_extra_cost_hint_eu' ),
			'type'     => 'wgm_ui_checkbox',
			'default'  => 'off',
		);

		/* Loop + Single Product: Advertise Free Shipping */
		$options[] = array(
			'name'     => __( 'Advertise Free Shipping', 'woocommerce-german-market' ),
			'desc_tip' => __( 'Replaces the mandatory Shipping page link with a line saying “Free Shipping”. This will <strong>not change any of your shipping settings</strong>. Make sure free shipping applies to all products before enabling this option.',
			                  'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: below tax line.', 'woocommerce-german-market' ),
			'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_show_free_shipping' ),
			'type'     => 'wgm_ui_checkbox',
			'default'  => 'off',
		);

		$options[ 'attribute_in_product_name' ] = array(
			'name'     => __( 'Product Attributes in product name', 'woocommerce-german-market' ),
			'desc_tip' => __( 'As default, the variation attributes are shown in the product name since WooCommerce 3.0. If this option is deactivated, the attributes are shown separated under the product name.', 'woocommerce-german-market' ),
			'id'       => 'german_market_attribute_in_product_name',
			'type'     => 'wgm_ui_checkbox',
			'default'  => 'off'
		);

		$options[] = array( 'type' => 'sectionend', 'id' => 'de_products' );


		$options = apply_filters( 'woocommerce_de_ui_options_products', $options );
		return $options;
	}

	/**
	* Render Options for cart_and_checkout
	* 
	* @access public
	* @return void
	*/
	public function cart_and_checkout() {

		$options = array(

			array(
				'name' => _x( 'Cart & Checkout', 'options panel heading', 'woocommerce-german-market' ),
				'desc' => __( 'The following options apply to the front-end of your online store.', 'woocommerce-german-market' ),
				'type' => 'title',
				'id'   => 'de_cart_checkout'
			),

			/* Cart: Show Links to Legal Pages */
			array(
				'name'     => __( 'Show Links to Legal Pages', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Adds a hint line to the cart table showing links to Shipping, Revocation and Payment Methods pages.', 'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: below last line item.', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_disclaimer_cart' ),
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on',
			),

			/* Cart: Disclaimer For Estimated Taxes & Shipping Costs */
			array(
				'name'     => __( 'Disclaimer For Estimated Taxes & Shipping Costs', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Adds a disclaimer note to the cart page that taxes and shipping costs will be estimated until customers have entered billing and shipping data during checkout.', 'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: below cart totals.', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_estimate_cart' ),
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on',
			),

			/* hide flat rate shipping if free shipping is available */
			array(
				'name'     => __( 'Hide shipping rates when free shipping is available', 'woocommerce-german-market' ),
				'id'       => 'wgm_dual_shipping_option',
				'type'     => 'wgm_ui_checkbox',
				'desc_tip' => __( 'After changing this setting, the option becomes effective for shop customers only when a new WooCommerce session is started. With the WooCommerce tools, you can also delete all sessions. Local Pickup is always displayed.', 'woocommerce-german-market' ),
				'default'  => 'off',
			),

			/* Cart + Checkout: Product Short Descriptions */
			array(
				'name'     => __( 'Show Short Description', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Display product short description during checkout.', 'woocommerce-german-market' ) . ' ' . __( 'Adds short description to line items if available.', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_show_show_short_desc' ),
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			/* Checkout: Check Revocation Policy */
			array(
				'name'     => __( 'Confirm Revocation Policy', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Adds a confirmation checkbox for the Revocation Policy on the checkout page.', 'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: first below payment methods.', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'woocommerce_de_show_Widerrufsbelehrung' ),
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on',
			),

			/* Checkout: Check Digital Revocation Policy */
			array(
				'name'     => __( 'Confirm digital Revocation Policy', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Adds a confirmation checkbox for the digital Revocation Policy on the checkout page.', 'woocommerce-german-market' ) . ' ' . __( 'Display position may vary. Default: first below payment methods.','woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'wgm_display_digital_revocation' ),
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on',
			),

			/* Phone Number is required Field */
			array(
				'name'     => __( 'Phone is a required field', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Deactivate this option if "Phone" shall not be a required field in checkout.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_phone_is_required_field_in_checkout',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on',
			),

			/* Checkout: Avoid Free Items In Cart */
			array(
				'name'     => __( 'Avoid Free Items In Cart', 'woocommerce-german-market' ),
				'desc_tip' => __( 'If you enable this option, customers can\'t checkout with a cart that contains one or more free items. So you can avoid unwanted orders. You can choose your error message in the option below.',
				                  'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_avoid_free_items_in_cart',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),  

			array(
				'name'     => __( 'Avoid Free Items In Cart - Error Message', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Choose the error message for the option above.',
				                  'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_avoid_free_items_in_cart_message',
				'type'     => 'textarea',
				'default'  => __( 'Sorry, you can\'t proceed to checkout. Please contact our support.', 'woocommerce-german-market' ),
				'custom_attributes' => array( 'rows' => '3', 'cols' => '80' ),
			),

			array(
				'name'     => __( 'Confirm & Place Order Page', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Adds the second checkout page "Confirm & Place Order" to the checkout process.',
				                  'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_secondcheckout',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			array(
				'name'     => __( 'Order Button Text', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Text of the "Order Button"', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_order_button_text',
				'type'     => 'text',
				'default'  => __( 'Place binding order', 'woocommerce-german-market' ),
				'css'	   => 'width: 500px;'
			),

			array(
				'name'     => __( 'Checkbox Text - Terms & Conditions', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Text of the Checkbox "Terms & Conditions". You can use [link][/link] to add the link to the "Terms & Conditions" page.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_checkbox_text_terms_and_conditions',
				'type'     => 'text',
				'default'  => __( 'I have read and accept the [link]terms & conditions[/link]', 'woocommerce-german-market' ),
				'css'	   => 'width: 500px;'
			),

			array(
				'name'     => __( 'Checkbox Text - Revocation Policy', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Text of the Checkbox "Revocation Policy". You can use [link][/link] to add the link to the "Revocation Policy" page.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_checkbox_text_revocation',
				'type'     => 'text',
				'default'  => __( 'I have read and accept the [link]Revocation Policy[/link]', 'woocommerce-german-market' ),
				'css'	   => 'width: 500px;'
			),

			array(
				'name'     => __( 'Checkbox Text - Revocation Policy for digital content.', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Text of the Checkbox "Revocation Policy". You can use [link][/link] to add the link to the "Revocation Policy for digital content" page.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_checkbox_text_revocation_digital',
				'type'     => 'text',
				'default'  => __( 'I have read and accept the [link]Revocation Policy for digital content[/link]', 'woocommerce-german-market' ),
				'css'	   => 'width: 500px;'
			),

			array(
				'name'     => __( 'Checkbox Text - For digital content.', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Text of the Checkbox "For digital content".', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_checkbox_text_digital_content',
				'type'     => 'textarea',
				'default'  => __( 'For digital content: You explicitly agree that we continue with the execution of our contract before expiration of the revocation period. You hereby also declare you are aware of the fact that you lose your right of revocation with this agreement.', 'woocommerce-german-market' ),
				'css'	   => 'width: 500px; height: 75px;'
			),

			array(
				'name'     => __( 'Show Checkout Boxes before Order Summary on Checkout Page', 'woocommerce-german-market' ),
				'desc_tip' => __( 'This option is not applied if the "Confirm & Place Order Page" is enabled.', 'woocommerce-german-market' ),
				'id'       => 'gm_order_review_checkboxes_before_order_review',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			array(
				'name'     => __( 'For digital content - Repetition.', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Repeat the text above in emails and possibly in invoice pdfs.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_repeat_digital_content',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on'
			),

			array(
				'name'     => __( 'For digital content - Position of Text Repetition in Emails.', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Position of the Repetition of the the text above in Emails.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_repeat_digital_content_notice_position',
				'type'     => 'select',
				'default'  => 'after',
				'options'  => array(
					'before' => __( 'Before Order table', 'woocommerce-german-market' ),
					'after'  => __( 'After Order Table', 'woocommerce-german-market' )
				)
			),

			array(
				'name'     => __( 'Text - Notice: Digital content.', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Text for the notice "For digital content".', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_checkbox_text_digital_content_notice',
				'type'     => 'textarea',
				'default'  => __( 'Notice: Digital content are products not being delivered on any physical medium (e.g. software downloads, e-books etc.).', 'woocommerce-german-market' ),
				'css'	   => 'width: 500px; height: 75px;'
			),

			array(
				'name'     => __( 'Learn more about shipping costs, payment methods and our revocation policy', 'woocommerce-german-market' ),
				'desc_tip' => __( 'You can use [link-shipping][/link-shipping], [link-payment][/link-payment], [link-revocation][/link-revocation], [link-privacy][/link-privacy] to add the specific links.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_learn_more_about_shipping_payment_revocation',
				'type'     => 'textarea',
				'default'  => __( 'Learn more about [link-shipping]shipping costs[/link-shipping], [link-payment]payment methods[/link-payment] and our [link-revocation]revocation policy[/link-revocation].', 'woocommerce-german-market' ),
				'css'	   => 'width: 500px; height: 75px;'
			),

			array( 'type' => 'sectionend', 'id' => 'de_cart_checkout' ),

			array(
				'name' => _x( 'Checkout Template / Theme Options', 'options panel heading', 'woocommerce-german-market' ),
				'type' => 'title',
				'id'   => 'de_checkout_template_theme_options',
				'desc' => __( 'If you recognize any problems in your shop during checkout (e.g. missing submit button) this is probably caused by your theme overriding the "form-checkout" and / or "terms" template of German Market. Activating one of the following options helps to fix these problems.', 'woocommerce-german-market' )
			),

			/* Template form-checkout.php */
			array(
				'name'     => __( 'Force to use German Market Checkout Template', 'woocommerce-german-market' ),
				'desc_tip' => __( 'If you activate this option, you can force to use the German Market template instead of your theme template.', 'woocommerce-german-market' ),
				'id'       => 'gm_force_checkout_template',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			array(
				'name'     => __( 'Deactivate German Market Hooks', 'woocommerce-german-market' ),
				'desc_tip' => __( 'If you activate this option, German Market will not hook into your checkout page to change the order of payment methods and order review.', 'woocommerce-german-market' ),
				'id'       => 'gm_deactivate_checkout_hooks',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			array( 'type' => 'sectionend', 'id' => 'de_checkout_template_theme_options' ),

			array(
				'name' => _x( 'Manual Order Confirmation', 'options panel heading', 'woocommerce-german-market' ),
				'type' => 'title',
				'id'   => 'de_manual_order_confirmation',
				'desc' => WGM_Ui::get_video_layer( 'https://s3.eu-central-1.amazonaws.com/videogm/manuelle-bestellannahme.mp4' )
			),

			array(
				'name'     => __( 'Manual Order Confirmation', 'woocommerce-german-market' ),
				'desc_tip' => __( 'With this option "Manual Order Confirmation" it is possible to check each order manually and to approve it before the order is accepted. If the option is activated, the customer receives only the e-mail order confirmation with the acceptance of the offer. Subsequently, the respective order can be checked and approved manually in the order overview.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_manual_order_confirmation',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			array( 'type' => 'sectionend', 'id' => 'de_manual_order_confirmation' ),

		);

		$options = apply_filters( 'woocommerce_de_ui_options_cart_and_checkout', $options );
		return $options;
	}

	/**
	* Render Options for global
	* 
	* @access public
	* @return void
	*/
	public function global_tab(){

		$locale              = get_locale();
		$is_de               = ( stripos( $locale, 'de' ) === 0 ) ? TRUE : FALSE;
		$support_url         = $is_de ? 'https://marketpress.de/hilfe/' : 'https://marketpress.com/help/';

		$options = array(

			array(
				'name' => _x( 'Global', 'options panel heading', 'woocommerce-german-market' ),
				'type' => 'title',
				'id'   => 'de_shop_global'
			),

			/* Global: Default Tax Label */
			array(
				'name'     => __( 'Default Tax Label', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Sets the default tax label (e.g. “VAT”). If empty, “VAT” will be used.', 'woocommerce-german-market' ) . ' ' . __( 'Disabling will not harm any functionality on your site, but may result in visual inconsistencies. Test FTW!', 'woocommerce-german-market' ),
				'id'       => WGM_Helper::get_wgm_option( 'wgm_default_tax_label' ),
				'type'     => 'text',
			),

			/* Global: Deactivate Split Tax Calculation */
			array(
				'name'     => __( 'Prorated Tax Calculation For Fees & Shipping Cost', 'woocommerce-german-market' ),
				'desc'	   => __( 'Mandatory method of calculating taxes for fees & shipping costs.', 'woocommerce-german-market' ) . ' ' . sprintf(
					__( 'Calculates taxes for fees and shipping costs based on the number of line items and tax rates present in cart. (Rarely considered, yet legally mandatory method in Germany and Austria. To learn more about how fee taxes are calculated read <a href="%s" target="_blank">this post</a>, or contact the <a href="%s" target="_blank">support team</a>.)',
					    'woocommerce-german-market' ),
					'https://marketpress.de/documentation/german-market/steuerberechnung-bei-nebenleistungen/',
					$support_url
				),
				'id'       => WGM_Helper::get_wgm_option( 'wgm_use_split_tax' ),
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on',
			),

			array(
				'name'     => __( 'Gross Shipping Costs and Gross Fees', 'woocommerce-german-market' ),
				'desc'	   => __( 'Treat shipping costs and fees that you can enter in WooCommerce settings as gross prices. Please not, that in that case, the corresponding net prices can vary, depending on the applied tax rates of the items in the customer\'s cart, especially when the option "Prorated Tax Calculation For Fees & Shipping Cost" is activated.', 'woocommerce-german-market' ),
				'id'       => 'gm_gross_shipping_costs_and_fees',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
			),

			/* Global: Use WGM CSS  */
			array(
				'name'     => __( 'Load Default CSS', 'woocommerce-german-market' ),
				'desc_tip' => __( 'Loads WooCommerce German Market’s CSS styles in the front-end. Disable if not needed. <strong>Note:</strong> Visual inconsistencies may occur even if you keep this enabled, depending on the WooCommerce templates included in your current theme. Usually those can be fixed via custom CSS, or in a child theme.', 'woocommerce-german-market' ) . ' ' . __( 'Disabling will not harm any functionality on your site, but may result in visual inconsistencies. Test FTW!', 'woocommerce-german-market' ),
				'id'       => 'load_woocommerce_de_standard_css',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'on',
			),

			/* Global: Due Date  */
			array(
				'name'     => __( 'Due Date', 'woocommerce-german-market' ),
				'desc_tip' => __( 'For each payment gateway you can specify a due date for orders. The due date will be shown in the customer emails and in the invoice pdf.', 'woocommerce-german-market' ),
				'id'       => 'woocommerce_de_due_date',
				'type'     => 'wgm_ui_checkbox',
				'default'  => 'off',
				'desc'	   => WGM_Ui::get_video_layer( 'https://s3.eu-central-1.amazonaws.com/videogm/faelligkeitsdatum.mp4' )
			),

			/* Global: Double Opt-in Customer Registration  */
			array(
 				'name'    => __( 'Double Opt-in Customer Registration', 'woocommerce-german-market' ),
 				'desc_tip'=> __( 'If customer chooses to create a customer account an email with an activation link will be sent by mail. Customer account will be marked as activated if user clicks on the link within the email.',
 				                 'woocommerce-german-market' ),
 				'id'      => 'wgm_double_opt_in_customer_registration',
 				'type'    => 'wgm_ui_checkbox',
 				'default' => 'off',
 				'desc'	   => WGM_Ui::get_video_layer( 'https://s3.eu-central-1.amazonaws.com/marketpress-videos/german-market/double-opt-in-kundenregistrierung.mp4' )
 			),

			array( 'type' => 'sectionend', 'id' => 'de_shop_global' ),
		);

		$options = apply_filters( 'woocommerce_de_ui_options_global', $options );
		return $options;
	}

	/**
	* Render Options for emails
	* 
	* @access public
	* @return void
	*/
	public function emails() {

		$options = array(

			array(
				'name' => _x( 'Emails', 'options panel heading', 'woocommerce-german-market' ),
				'type' => 'title',
				'id'   => 'de_shop_emails'
			),

			array(
				'name'    => __( 'Send Order Confirmation Mail', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Send Order Confirmation Mail after an Order is completed.',
				                 'woocommerce-german-market' ),
				'id'      => WGM_Helper::get_wgm_option( 'wgm_send_order_confirmation_mail' ),
				'type'    => 'wgm_ui_checkbox',
				'default' => 'on',
			),

			array(
				'name'    => __( 'Use plain text Order Confirmation mail', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Use the plain text version of the Order Confirmation Mail.',
				                 'woocommerce-german-market' ),
				'id'      => WGM_Helper::get_wgm_option( 'wgm_plain_text_order_confirmation_mail' ),
				'type'    => 'wgm_ui_checkbox',
				'default' => 'off',
			),

			array(
				'name'    => __( 'Legal Texts Attachments', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Adds the necessary legal texts inline to the emails.', 'woocommerce-german-market' ),
				'id'      => 'wgm_email_footer_general',
				'type'    => 'wgm_ui_checkbox',
				'default' => 'on',
			),

			array(
				'name'    => __( 'Email attachments for Shop Admin Emails', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Adds the necessary legal texts and attachment files also to the emails ("New order", "Cancelled order" and "Failed order") that are send to the shop admin.',
				                 'woocommerce-german-market' ),
				'id'      => 'wgm_email_footer_in_admin_emails',
				'type'    => 'wgm_ui_checkbox',
				'default' => 'on',
			),

			array( 'type' => 'sectionend', 'id' => 'de_shop_emails' ),
		);

		$file_attachments = array(

			array(
				'name' => _x( 'File Attachments', 'options panel heading', 'woocommerce-german-market' ),
				'type' => 'title',
				'id'   => 'de_shop_emails_file_attachments',
				'desc' => WGM_Ui::get_video_layer( 'https://s3.eu-central-1.amazonaws.com/videogm/statische-mail-anhaenge.mp4' )
			),

			array(
				'name'    => __( 'Number of Files', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'If you deactivated the necessary legal texts in the emails, you should add PDF files with your terms of condition, recovation policy, etc. Choose the number of files that you want to attache here.',
				                 'woocommerce-german-market' ),
				'id'      => 'de_shop_emails_file_attachments_nr',
				'type'    => 'number',
				'custom_attributes' => array(
					'min'	=> 0,
					'max'	=> apply_filters( 'de_shop_emails_file_attachments_nr', 10 )
				),
				'default' => 1,
			),
		);

		$image_upload_button = '<button type="button" class="button-secondary de_shop_emails_file_attachments_upload_button" id="de_shop_emails_file_attachments_upload_button_PART" style="margin: 3px 0;">' . __( 'Attachment Upload', 'woocommerce-german-market' ) . '</button>';
		
		$image_remove_button = '<button type="button" class="button-secondary de_shop_emails_file_attachments_remove_button" id="de_shop_emails_file_attachments_remove_button_PART" style="margin: 3px 3px;">' . __( 'Remove Attachment', 'woocommerce-german-market' ) . '</button>';

		for ( $i = 1; $i <= apply_filters( 'de_shop_emails_file_attachments_nr', 10 ); $i++ ) {

			$the_image_upload_button = str_replace( 'PART', $i, $image_upload_button );
			$the_image_remove_button = str_replace( 'PART', $i, $image_remove_button );

			$file_attachments[] = array(
				'name'    => __( 'Attachment', 'woocommerce-german-market' ) . ' ' . $i,
				'desc'	  => '<br />' . $the_image_upload_button . $the_image_remove_button,
				'desc_tip'=> __( 'Click the upload button to use the media uploader. Click the "Insert into Post" button in the media uploader to add the attachment here.', 'woocommerce-german-market' ),
				'id'      => 'de_shop_emails_file_attachment_' . $i,
				'type'    => 'text',
				'default' => '',
				'class'	  => 'de_shop_emails_file_attachment',
				'css'     => 'min-width:500px;'
			);
		}

		$file_attachments[] = array( 'type' => 'sectionend', 'id' => 'de_shop_emails_file_attachments' );

		$bcc = array(

			array(
				'name' => _x( 'BCC / CC Recipients', 'options panel heading', 'woocommerce-german-market' ),
				'type' => 'title',
				'id'   => 'de_shop_emails_cc_bcc',
				'desc' => 'You can add CC or BCC recipients to the emails that are send to the customer.'
			),

			array(
				'name'    => __( 'Email addresses', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Enter comma-seperated email addresses of Recipients.','woocommerce-german-market' ),
				'id'      => 'wgm_email_cc_bcc_receivers',
				'type'    => 'text',
				'default' => '',
				'css'	  => 'width: 300px;'
			),

			array(
				'name'    => __( 'BBC / CC', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Choose whether the recipients are added as BCC or CC.', 'woocommerce-german-market' ),
				'id'      => 'wgm_email_cc_bcc_type',
				'type'    => 'select',
				'options' => array(
					'bcc'	=> 'BCC',
					'cc'	=> 'CC'
				),
				'default' => 'BCC',
				'css'	  => 'width: 300px;'
			),

			array(
				'name'    => __( 'Order Confirmation', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Add BCC / CC recipients to Order Confirmation Email.', 'woocommerce-german-market' ),
				'id'      => 'wgm_email_cc_bcc_customer_order_confirmation',
				'type'    => 'wgm_ui_checkbox',
				'default' => 'off',
			),

			array(
				'name'    => __( 'On Hold', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Add BCC / CC recipients to On Hold Email.', 'woocommerce-german-market' ),
				'id'      => 'wgm_email_cc_bcc_customer_on_hold_order',
				'type'    => 'wgm_ui_checkbox',
				'default' => 'off',
			),

			array(
				'name'    => __( 'Processing Order', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Add BCC / CC recipients to Processing Order Email.', 'woocommerce-german-market' ),
				'id'      => 'wgm_email_cc_bcc_customer_processing_order',
				'type'    => 'wgm_ui_checkbox',
				'default' => 'off',
			),

			array(
				'name'    => __( 'Completed Order', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Add BCC / CC recipients to Completed Order Email.', 'woocommerce-german-market' ),
				'id'      => 'wgm_email_cc_bcc_customer_completed_order',
				'type'    => 'wgm_ui_checkbox',
				'default' => 'off',
			),

			array(
				'name'    => __( 'Refunded Order', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Add BCC / CC recipients to Refunded Order Email.', 'woocommerce-german-market' ),
				'id'      => 'wgm_email_cc_bcc_customer_refunded_order', // customer_partially_refunded_order
				'type'    => 'wgm_ui_checkbox',
				'default' => 'off',
			),

			array(
				'name'    => __( 'Invoice', 'woocommerce-german-market' ),
				'desc_tip'=> __( 'Add BCC / CC recipients to Invoice Email.', 'woocommerce-german-market' ),
				'id'      => 'wgm_email_cc_bcc_customer_invoice',
				'type'    => 'wgm_ui_checkbox',
				'default' => 'off',
			),


			array( 'type' => 'sectionend', 'id' => 'de_shop_emails' ),

		);

		$options = array_merge( $options, $file_attachments, $bcc );

		$options = apply_filters( 'woocommerce_de_ui_options_emails', $options );
		return $options;

	}

	/**
	* Render Add-On Tab
	* 
	* @access public
	* @return array
	*/
	public static function render_add_ons() {

		// Init
		$add_ons = self::get_addons();
		
		// Update Options
		if ( isset( $_POST[ 'update_add_ons' ] ) ) {

			if ( ! wp_verify_nonce( $_POST[ 'update_add_ons' ], 'woocommerce_de_update_add_ons' ) ) {

				?>
				<div class="notice notice-error">
			        <p><?php echo __( 'Sorry, but something went wrong while saving your settings. Please, try again.', 'woocommerce-german-market' ); ?></p>
			    </div>
			    <?php

			} else {

				foreach ( $add_ons as $add_on ) {

					if ( isset( $_POST[ $add_on[ 'id' ] ] ) ) {
						$current_activation = $add_on[ 'on-off' ];
						$new_activation = $current_activation == 'on' ? 'off' : 'on';
						update_option( $add_on[ 'id' ], $new_activation );
					}

				}

				// Do a little trick (add-ons are activated after second reload)
				wp_safe_redirect( get_admin_url() . 'admin.php?page=german-market&tab=add-ons&updated_wgm_add_ons=' . time() );
				exit();

			}

		}

		// Show notice when settings have been saved
		if ( isset( $_REQUEST[ 'updated_wgm_add_ons' ] ) ) {
			
			// If someone reloads the page, the message should not be shown
			if ( intval( $_REQUEST[ 'updated_wgm_add_ons' ] ) + 1 >= time() ) {

				?>
				<div class="notice notice-success">
			        <p><?php echo __( 'Your settings have been saved.', 'woocommerce-german-market' ); ?></p>
			    </div>
			    <?php

			}
		}

		?>	
			<form method="post">

				<?php wp_nonce_field( 'woocommerce_de_update_add_ons', 'update_add_ons' ); ?>

				<div class="add-ons">

					<div class="description">
					</div>

					<?php

						foreach ( $add_ons as $add_on ) {

							?>
								<div class="add-on-box <?php echo $add_on[ 'on-off' ]; ?>">

									<div class="icon logo-box">
										<?php if ( $add_on[ 'image' ] != '' ) { ?>
											
											<img src="<?php echo $add_on[ 'image' ]; ?>" alt="logo" />

										<?php } else if ( $add_on[ 'dashicon' ] != '' ) { ?>

											<span class="dashicons dashicons-<?php echo $add_on[ 'dashicon' ]; ?>"></span>

										<?php } else { ?>

											<span class="dashicons dashicons-admin-generic"></span>

										<?php } ?>

									</div>

									<div class="on-off-box">

										<label class="switch">
											<?php
												
												if ( $add_on[ 'on-off' ] == 'on' ) {

													?><input type="submit" class="add-on-switcher on" name="<?php echo $add_on[ 'id' ]; ?>" value="" /><div class="slider round"></div><?php

												} else if ( $add_on[ 'on-off' ] == 'off' ) {

													?><input type="submit" class="add-on-switcher off" name="<?php echo $add_on[ 'id' ]; ?>" value="" /><div class="slider round"></div><?php

												}

											?>
										</label>

									</div>

									<span style="clear: both; display: block;"></span>

									<div class="title">
										<?php echo $add_on[ 'title' ]; ?>
									</div>

									<div class="description">
										<?php echo $add_on[ 'description']; ?>
									</div>

									<div class="video">
											<?php if ( isset( $add_on[ 'video' ] ) && $add_on[ 'video' ] != '' ) {
												echo self::get_video_layer( $add_on[ 'video' ] );
											}
										?>
									</div>

								</div>

						<?php } ?>

				</div>

			</form>

		<?php
	}

	/**
	* Get Add-Ons
	* 
	* @access private
	* @return array
	*/
	private static function get_addons() {

		$refund_on_off = 'always-off';
		$add_ons_refund = array( 'wgm_add_on_online_buchhaltung', 'wgm_add_on_sevdesk', 'wgm_add_on_lexoffice', 'wgm_add_on_woocommerce_running_invoice_number', 'wgm_add_on_woocommerce_invoice_pdf' );
		foreach ( $add_ons_refund as $add_on_refund ) {
			if ( get_option ( $add_on_refund ) == 'on' ) {
				$refund_on_off ='always-on';
				break;
			}
		}

		$add_ons = array(

			array( 
				'title'				=> __( 'Refunds', 'woocommerce-german-market' ),
				'description'		=> __( 'German Market supports special actions for your refunds. The "All Refunds" submenu is automatically available if one of these add-ons is activated: Invoice Number, Invoice PDF, Lexoffice, sevDesk.', 'woocommerce-german-market' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-storno.jpg',
				'dashicon'			=> 'welcome-view-site',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/marketpress-videos/german-market/storno.mp4',
				'on-off'			=> $refund_on_off,
				'id'				=> 'refund'
			),

			array( 
				'title'				=> __( 'EU VAT Number Check', 'woocommerce-german-market' ),
				'description'		=> __( 'Adds a field for value-added tax identitification number (VATIN) during checkout. Validates field entries against the official web site of the <a href="http://ec.europa.eu/taxation_customs/vies/vieshome.do?locale=en">European Commission</a>', 'woocommerce-german-market' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-eumwst.jpg',
				'dashicon'			=> '',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/videogm/ustid.mp4',
				'on-off'			=> get_option( 'wgm_add_on_woocommerce_eu_vatin_check' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_woocommerce_eu_vatin_check'
			),
			
			array( 
				'title'				=> __( 'WooCommerce EU VAT Checkout', 'woocommerce-german-market' ),
				'description'		=> __( 'Fixate prices for EU consumers in your WooCommerce store. This Add-On will display fixed gross prices and dynamically recalculate taxes (VAT) included in those prices. EU tax rates can be configured in and will be retrieved from the default WooCommerce tax table.', 'woocommerce-german-market' ) . ' <a href="https://marketpress.de/documentation/german-market/eu-mehrwertsteuer/konfiguration/" target="_blank">' . __( 'Configuration Documentation', 'woocommerce-german-market' ) . '</a>',
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-eumwst.jpg',
				'dashicon'			=> '',
				'video'				=> '',
				'on-off'			=> get_option( 'wgm_add_on_woocommerce_eu_vat_checkout' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_woocommerce_eu_vat_checkout'
			),

			array( 
				'title'				=> __( 'Return / Delivery Note PDF', 'woocommerce-german-market' ),
				'description'		=> __( 'This add-on adds a Retoure PDF as an attachment to customer emails, enables backend download of the pdf and customer download on the my account page.', 'woocommerce-german-market' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-retourepdf.jpg',
				'dashicon'			=> '',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/marketpress-videos/german-market/retourenschein.mp4',
				'on-off'			=> get_option( 'wgm_add_on_woocommerce_return_delivery_pdf' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_woocommerce_return_delivery_pdf'
			),

			array( 
				'title'				=> __( 'Invoice Number', 'woocommerce-german-market' ),
				'description'		=> __( 'This add-on adds a running invoice number to your orders.', 'woocommerce-german-market' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-rnr.jpg',
				'dashicon'			=> '',
				'video'				=> '',
				'on-off'			=> get_option( 'wgm_add_on_woocommerce_running_invoice_number' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_woocommerce_running_invoice_number'
			),

			array( 
				'title'				=> __( 'Invoice PDF', 'woocommerce-german-market' ),
				'description'		=> __( 'This add-on adds an Invoice PDF as an attachment to customer emails, enables backend download of the pdf and customer download on the my account page.', 'woocommerce-german-market' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-rechnungpdf.jpg',
				'dashicon'			=> '',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/marketpress-videos/german-market/rechnungspdf.mp4',
				'on-off'			=> get_option( 'wgm_add_on_woocommerce_invoice_pdf' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_woocommerce_invoice_pdf'
			),

			array( 
				'title'				=> __( 'Lexoffice', 'woocommerce-german-market' ),
				'description'		=> __( 'This add-on is a Lexoffice API.', 'woocommerce-german-market' ) . '<br /><br />' . sprintf ( __( "You can register <a href=\"%s\" target=\"_blank\">here</a> if you don't have a lexoffice account, yet", 'woocommerce-german-market' ), 'https://app.lexoffice.de/signup?pid=1443' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-lexoffice.jpg',
				'dashicon'			=> '',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/marketpress-videos/german-market/lexoffice.mp4',
				'on-off'			=> get_option( 'wgm_add_on_lexoffice' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_lexoffice'
			),

			array( 
				'title'				=> __( 'sevDesk', 'woocommerce-german-market' ),
				'description'		=> __( 'This add-on activates the sevDesk API.', 'woocommerce-german-market' ) . '<br /><br />' . sprintf ( __( "You can register <a href=\"%s\" target=\"_blank\">here</a> if you don't have a sevDesk account, yet.", 'woocommerce-german-market' ), 'https://sevdesk.de/register/?utm_source=integrations&utm_medium=referral&utm_campaign=marketpress' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-sevdesk.jpg',
				'dashicon'			=> '',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/marketpress-videos/german-market/sevdesk.mp4',
				'on-off'			=> get_option( 'wgm_add_on_sevdesk' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_sevdesk'
			),

			array( 
				'title'				=> __( '1&1 Online-Buchhaltung', 'woocommerce-german-market' ),
				'description'		=> __( 'This add-on activates the <a href="https://hosting.1und1.de/buchhaltung-online?linkId=hd.subnav.online-accounting" target="_blank">1&1 Online-Buchhaltung</a> API.', 'woocommerce-german-market' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-online-buchhaltung.jpg',
				'dashicon'			=> '',
				'on-off'			=> get_option( 'wgm_add_on_online_buchhaltung' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_online_buchhaltung'
			),

			array( 
				'title'				=> __( 'IT-Recht Kanzlei', 'woocommerce-german-market' ),
				'description'		=> __( '<a href="http://www.it-recht-kanzlei.de/Service/german-market-agb.php?partner_id=294" target="_blank">Dunning-proof legal texts</a> for your shop. Monthly only 8.90 € + 2 months free + monthly cancelable.', 'woocommerce-german-market' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-it-recht-kanzlei.png',
				'dashicon'			=> '',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/marketpress-videos/german-market/it-recht-kanzlei.mp4',
				'on-off'			=> get_option( 'wgm_add_on_it_recht_kanzlei' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_it_recht_kanzlei'
			),

			array( 
				'title'				=> __( 'Protected Shops', 'woocommerce-german-market' ),
				'description'		=> __( 'Benefit from our <a href="https://www.protectedshops.de/unsere-schutzpakete" target="_blank">exclusive partner offer</a>. With the coupon code PS-GM-3X, new customers of Protected Shops receive 3 months for free - use 15 months and pay only 12 months.', 'woocommerce-german-market' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-protected-shops.png',
				'dashicon'			=> '',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/marketpress-videos/german-market/protected-shops.mp4',
				'on-off'			=> get_option( 'wgm_add_on_protected_shops' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_protected_shops'
			),

			array( 
				'title'				=> __( 'Billbee', 'woocommerce-german-market' ),
				'description'		=> __( 'This Add-On allows you to open your WooCommerce order direcetly in Billbee.', 'woocommerce-german-market' ) . '<br /><br />' . sprintf ( __( "You can register <a href=\"%s\" target=\"_blank\">here</a> for a free and not binding 30-day test period.", 'woocommerce-german-market' ), 'https://www.billbee.de?acc=yqxflqpu' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-billbee.jpg',
				'dashicon'			=> '',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/marketpress-videos/german-market/billbee.mp4',
				'on-off'			=> get_option( 'wgm_add_on_billbee' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_billbee'
			),
			
			array( 
				'title'				=> __( 'FIC', 'woocommerce-german-market' ),
				'description'		=> __( 'This add-on allows you to add legally nesseccary information about nutritional values and allergenes to your products respecting the EU Food Information for Consumers Regulation.', 'woocommerce-german-market' ),
				'image'				=> plugins_url() . '/woocommerce-german-market/images/addon-fic.jpg',
				'dashicon'			=> '',
				'video'				=> 'https://s3.eu-central-1.amazonaws.com/videogm/lmiv.mp4',
				'on-off'			=> get_option( 'wgm_add_on_fic' ) == 'on' ? 'on' : 'off',
				'id'				=> 'wgm_add_on_fic'
			),

		);

		return apply_filters( 'woocommerce_de_add_ons_menu_list', $add_ons );

	}

	/**
 	* Get Save Button
 	*
 	* @return void
 	*/
	private function save_button( $class = 'top' ) {
		?><input type="submit" name="submit_save_wgm_options" class="save-wgm-options <?php echo $class; ?>" value="<?php echo __( 'Save changes', 'woocommerce-german-market' ); ?>" /><?php
	}

	/**
	* Get Video Div
	*
	* @access privat
	* @static
	* @param String $text
	* @param String $url
	* @return String
	*/
	public static function get_video_layer( $url ) {
		return '<div class="wgm-video-wrapper">
					<span class="url">' . $url . '</span>
					<a class="open"><span class="dashicons dashicons-format-video icon"></span>' . __( 'Video', 'woocommerce-german-market' ) .'</a>
					<div class="videoouter">
                        <div class="videoinner">
                            <a class="close">' . __( 'Close', 'woocommerce-german-market' ) .'<span class="dashicons dashicons-no-alt icon"></span></a>
                            <div class="video"></div>
                        </div>
                    </div>
				</div>';
	}

}
