<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} 

/**
* Add Product Meta
*
* @wp-hook woocommerce_product_options_general_product_data
* @wp-hook woocommerce_product_options_general_product_data
* @param Mixed $loop
* @param Mixed $variation_data
* @param Mixed $variation
* @return void
**/
function gm_fic_product_options( $loop = NULL, $variation_data = NULL, $variation = NULL ) {

	// init
	$is_variation = ( ! is_null( $variation ) );
	$name_suffix = '';
	$label_style = 'width: 300px;';
	$input_style = '';

	if ( ! $is_variation ) {

		$id = get_the_ID();
		?><div class="options_group"><?php
	
	} else {

		$name_suffix = '_variable[' . $loop . ']';
		$id          = $variation->ID;
		$label_style = 'width: 300px; float:left;';
		$input_style = 'width: 40%;';

	}

		?>
		
		<p class="form-field">
			<label style="cursor: default; width: 100%;">
				<b><?php echo get_option( 'gm_fic_ui_frontend_labels_nutritional_values', __( 'Nutritional Values', 'woocommerce-german-market' ) ); ?></b>
				<small><br /><?php echo __( '* Fields are legally required', 'woocommerce-german-market' ); ?></small>
				<?php if ( $variation ) { ?>
					<small><br /><?php echo __( 'Values of empty fields in this variation will inherit their value from the parent product.', 'woocommerce-german-market' );?></small>
				<?php } ?>

			</label>
		</p>

		<?php
			if( ! in_array( '_nutritional_values_remark', get_post_custom_keys( $id ) ) ) {
				$remark = get_option( 'gm_fic_ui_frontend_remark_nutritional_values', __( 'Nutritional values per 100g', 'woocommerce-german-market' ) );
			} else {
				$remark = get_post_meta( $id, '_nutritional_values_remark', true );
			}
		?>

		<p class="form-field">
			<label style="width: 300px; float: left;" for="_nutritional_values_remark<?php echo $name_suffix; ?>"><?php echo __( 'Remark', 'woocommerce-german-market' ); ?>:</label>
			<textarea style="width: 50%;" name="_nutritional_values_remark<?php echo $name_suffix; ?>" id="_nutritional_values_remark<?php echo $name_suffix; ?>"><?php echo $remark; ?></textarea>
		</p>


		<?php

		$terms = get_terms( 'gm_fic_nutritional_values', array( 'orderby' => 'slug', 'hide_empty' => 0 ) );
		$default_nutritionals = gm_fic_get_default_nutritionals();
		$prefix = get_option( 'gm_fic_ui_frontend_prefix_nutritional_values', __( '- of which', 'woocommerce-german-market' ) );
		
		if ( $prefix != '' ) {
			$prefix = $prefix . ' ';
		}
		
		foreach ( $terms as $term ) {

			$value = get_post_meta( $id, '_nutritional_values_' . $term->slug, true );

			$required = false;
			if ( isset( $default_nutritionals[ $term->slug ] ) ) {
				$required = isset( $default_nutritionals[ $term->slug ][ 'required' ] ) && $default_nutritionals[ $term->slug ][ 'required' ];
			}

			$required_string = $required ? '*' : '';
			
			// prefix if term has parent
			$prefix_string = '';
			if ( isset( $default_nutritionals[ $term->slug ] ) ) {
				$has_parent = isset( $default_nutritionals[ $term->slug ][ 'parent' ] ) && $default_nutritionals[ $term->slug ][ 'parent' ];
				if ( $has_parent ) {
					$prefix_string = $prefix;
				}
			} else {
				if ( isset( $term->parent ) && $term->parent > 0 ) {
					$prefix_string = $prefix;
				}
			}
			
			?>
				<p class="form-field">
					<label style="<?php echo $label_style; ?>" for="_nutritional_values_<?php echo $term->slug . $name_suffix; ?>"><?php echo $prefix_string . $term->name . $required_string; ?>:</label>
					<input style="<?php echo $input_style; ?>" type="text" name="_nutritional_values_<?php echo $term->slug . $name_suffix; ?>" id="_nutritional_values_<?php echo $term->slug . $name_suffix; ?>" value="<?php echo $value; ?>"/>
				</p>

			<?php
	
		}
		
		if ( ! $is_variation ) {
			?></div><div class="options_group"><?php
		}
		?>
        
		<p class="form-field" style="margin-bottom: 0; padding-bottom: 0;">
			<label style="cursor: default; width: 100%;">
				<b><?php echo get_option( 'gm_fic_ui_frontend_labels_allergens', __( 'Allergens', 'woocommerce-german-market' ) ); ?></b>
				<?php if ( $variation ) { ?>
					<small><br /><?php echo __( 'If this field is empty in this variation it will inherit its value from the parent product.', 'woocommerce-german-market' );?></small>
				<?php } ?>
			</label>
		</p>
        
        <?php $allergens_info = get_post_meta( $id, '_allergens_info', true ); ?>
        <?php $style = $is_variation ? '' : 'margin-top: 0;'; ?>

        <p class="form-field" style="<?php echo $style; ?>">
			<label style="width: 300px; float: left;" for="_allergens_info<?php echo $name_suffix; ?>"><?php echo __( 'Information', 'woocommerce-german-market' ); ?>:</label>
			<textarea style="width: 50%;" name="_allergens_info<?php echo $name_suffix; ?>" id="_allergens_info<?php echo $name_suffix; ?>"><?php echo $allergens_info; ?></textarea>
		</p>
        <?php


		if ( ! $is_variation ) {
			?></div><div class="options_group"><?php
		}
		?>
        
		<p class="form-field" style="margin-bottom: 0; padding-bottom: 0;">
			<label style="cursor: default; width: 100%;">
				<b><?php echo __( 'Alcohol Content', 'woocommerce-german-market' ); ?></b>
				<?php if ( $variation ) { ?>
					<small><br /><?php echo __( 'If this field is empty in this variation it will inherit its value from the parent product.', 'woocommerce-german-market' );?></small>
				<?php } ?>
			</label>
		</p>

		<?php 
			$alc_value = get_post_meta( $id, '_alcohol_value', true );
			$alc_unit = get_post_meta( $id, '_alcohol_unit', true );

			if ( $alc_unit == '' && $alc_value == '' ) {
				$alc_unit = get_option( 'gm_fic_ui_alocohol_default_unit', __( '% vol', 'woocommerce-german-market' ) );
			} 
		?>

		<p class="form-field" style="<?php echo $style; ?>">
			<label style="width: 300px; float: left;" for="_alcohol_value<?php echo $name_suffix; ?>"><?php echo __( 'Value', 'woocommerce-german-market' ); ?>:</label>
			<input type="text" style="width: 100px;" name="_alcohol_value<?php echo $name_suffix; ?>" id="_alcohol_value<?php echo $name_suffix; ?>" value="<?php echo $alc_value; ?>" />
		</p>

		<p class="form-field" style="<?php echo $style; ?>">
			<label style="width: 300px; float: left;" for="_alcohol_unit<?php echo $name_suffix; ?>"><?php echo __( 'Unit', 'woocommerce-german-market' ); ?>:</label>
			<input type="text" style="width: 100px;" name="_alcohol_unit<?php echo $name_suffix; ?>" id="_alcohol_unit<?php echo $name_suffix; ?>" value="<?php echo $alc_unit; ?>" />
		</p>
        
        
        <?php


	if ( ! $is_variation ) {
		?></div><?php
	}

}

/**
* Save Product Meta
*
* @wp-hook woocommerce_process_product_meta
* @wp-hook woocommerce_ajax_save_product_variations
* @param Integer $post_id
* @param WP_Post $post
* @return void
**/
function gm_fic_product_options_save( $post_id, $post = NULL ) {

	$simple = ( current_action() !== 'woocommerce_ajax_save_product_variations' );

	if ( ! empty( $_POST[ 'variable_post_id' ] ) ) {
		$variation_ids = $_POST[ 'variable_post_id' ];
	} else {
		$variation_ids = array();
	}

	$terms = get_terms( 'gm_fic_nutritional_values', array( 'orderby' => 'slug', 'hide_empty' => 0 ) );
	foreach ( $terms as $term ) {
		$meta_keys[ '_nutritional_values_' . $term->slug ] = '';
	}


	$meta_keys[ '_nutritional_values_remark' ] = '';
	$meta_keys[ '_allergens_info' ] = '';
	$meta_keys[ '_alcohol_value' ] = '';
	$meta_keys[ '_alcohol_unit' ] = '';
	
	if ( $simple ) {
		foreach ( $meta_keys as $key => $fallback_value ) {
			$value = WGM_Settings::get_post_value( $key, $fallback_value );
			update_post_meta( $post_id, $key, stripslashes( $value ) );
		}
	}

	foreach ( $variation_ids as $i => $post_id ) {

		foreach ( $meta_keys as $key => $fallback_value ) {
			$value = WGM_Settings::get_post_value( $key, $fallback_value, $i );
			update_post_meta( $post_id, $key, stripslashes( $value ) );
		}

	}

}
